' Summary: dospart.bas
' Partition Table FS driver
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/atabus.bi"
#include "mos/block.bi"
#include "mos/file.bi"
#include "x86.bi"
#include "mos.bi"

#include "roottrace.bi"

Dim shared vram As Byte Ptr

Declare Sub Dospart_ScanPartitions(ByVal info As Byte Ptr, ByVal devaddr As Integer, ByVal Mapping as Integer, ByVal startblock as Long)
Declare Sub Dospart_IndexToMapping(ByVal info As Byte Ptr, ByVal Sender As Integer, ByVal Index As Integer)
Declare Function ReadDevblock(ByVal DevAddr as Integer, ByVal Mapping as Integer, ByVal dataout as Unsigned Byte Ptr, ByVal block as Long) As Integer

Sub showbyte(ByVal b As Integer)
    outportb(&HE9, b)
End Sub

Sub showstring(ByRef s As String)
    Dim lp As Integer
    For lp = 0 to Len(s)
        showbyte(asc(mid$(s, lp, 1)))
    Next lp
End Sub

Type PARTITION
    Dim StartLocation as Long
    Dim EndLocation as Long
    Dim MapIndex As Integer
End Type

Type PARTITION_DATA
    Partitions as PARTITION Ptr
    partitioncount As Integer
    parentid As Integer
    parentaddr As Integer
    storageid As Integer
    storageaddr As Integer
    mapping As Integer
End Type

Sub modmain CDecl Alias "main" (ByVal argc As Integer, ByVal argv As Byte Ptr Ptr)

    Dim devid As Integer, parentid As Integer, parentaddr As Integer
    Dim storageid As Integer, storageaddr As Integer
    Dim storageid2 As Integer, mapping As Integer

    devid = DriverInit
    drv_setname(0,1)

    Dim msgsize As Integer
    Dim msg() As integer
    Redim msg(2)

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HE9, 1)

    showbyte(asc("D"))
    showbyte(asc("O"))
    showbyte(asc("S"))
    showbyte(asc("@"))
    showbyte(asc("0") + (devid \ 10))
    showbyte(asc("0") + (devid Mod 10))
    
    showbyte(asc("<"))
    If LocateParent(devid, parentid, parentaddr) > 0 Then
        showbyte(asc("P"))
        showbyte(asc("!"))
        Exit Sub
    End if

    showbyte(asc("0") + (parentid \ 10))
    showbyte(asc("0") + (parentid Mod 10))
    showbyte(asc(","))

    If LocateStorage(devid, storageid, storageaddr) > 0 Then
        showbyte(asc("S"))
        showbyte(asc("!"))
        Exit Sub
    End if

    showbyte(asc("0") + (storageid \ 10))
    showbyte(asc("0") + (storageid Mod 10))
    showbyte(asc(","))

    If GetStorage(devid, storageid2, mapping) > 0 Then
        showbyte(asc("M"))
        showbyte(asc("!"))
        Exit Sub
    End if

    showbyte(asc("0") + (storageid2 \ 10))
    showbyte(asc("0") + (storageid2 Mod 10))
    showbyte(asc(","))

    showbyte(asc("0") + (mapping \ 10))
    showbyte(asc("0") + (mapping Mod 10))

    showbyte(asc(">"))

    Dim localdata AS PARTITION_DATA
    localdata.Partitions = CPtr(Partition Ptr, 0)
    localdata.parentid = 0
    localdata.parentaddr = 0
    localdata.storageid = storageid2
    localdata.storageaddr = storageaddr
    localdata.mapping = mapping
    localdata.partitioncount = 0

    Dospart_ScanPartitions(Cptr(Byte ptr, @localdata), storageaddr, mapping, 0)

    ' register driver in device manager
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )



    While 1 = 1
        Dim rv As Integer, sender As Integer
        rv = drv_peekmessage()
        While rv = 0
            Yield
            rv = drv_peekmessage
        Wend

        redim msg((rv + 3) \ 4)
        sender = drv_readmessage(CPtr(Byte Ptr, @(msg(0))))
        Select Case msg(0)
            Case SYSCOMMAND_QUERYINTERFACES
                Redim msg(2)
                msg(0) = SYSCOMMAND_QUERYINTERFACES
                msg(1) = INTERFACE_FILESEGMENT
                drv_sendmessage(sender, 8, CPtr(Byte Ptr, @(msg(0))))

            Case FILECOMMAND_SEGCOUNT
                Redim msg(2)
                msg(0) = FILECOMMAND_SEGCOUNT
                msg(1) = localdata.partitioncount
                drv_sendmessage(sender, 8, CPtr(Byte Ptr, @(msg(0))))

            Case FILECOMMAND_GETSEG
                If msg(1) >= 0 And msg(1) < localdata.partitioncount Then
                    Dim partitionindex As Integer
                    partitionindex = msg(1)
                    Redim msg(8)
                    msg(0) = FILECOMMAND_GETSEG
                    msg(1) = partitionindex
                    msg(2) = localdata.storageid
                    msg(3) = localdata.storageaddr
                    msg(4) = localdata.partitions[partitionindex].MapIndex
                    msg(5) = (localdata.partitions[partitionindex].EndLocation - localdata.partitions[partitionindex].StartLocation + 1) And &H00000000FFFFFFFF&
                    msg(6) = (localdata.partitions[partitionindex].EndLocation - localdata.partitions[partitionindex].StartLocation + 1) SHR 32
                    drv_sendmessage(sender, 30, CPtr(Byte Ptr, @(msg(0))))
                End If

        End Select

    Wend

End Sub

Sub Dospart_ScanPartitions(ByVal info As Byte Ptr, ByVal devaddr As Integer, ByVal Mapping as Integer, ByVal startblock as Long)
    ' read the block in question
    Dim bytes() As Byte
    redim bytes(512)
    Dim lp As Integer

    Dim partdata As PARTITION_DATA Ptr
    partdata = CPtr(PARTITION_DATA Ptr, info)

    ReadDevblock(devaddr, mapping, @(bytes(0)), startblock)

    Dim pread as Unsigned Integer Ptr
    Dim count As Integer
    If startblock = 0 Then ' MBR
        Dim lp As Integer
        pread = CPtr(Unsigned Integer Ptr, @(bytes(446))) ' start of partition table
        count = 4
    Else ' extended partition
        count = 0
    End If

    While count > 0
        Dim LBAstart As Unsigned Integer
        Dim LBAsize As Unsigned Integer

        LBAStart = pread[2]
        LBASize = pread[3]
        pread = @(pread[4])

        If LBASize > 0 And LBAStart > 0 Then
            Dim msg(10) As Unsigned Integer
            msg(0) = BLOCKDRIVERCOMMAND_ADDMAP
            msg(1) = 0
            msg(2) = LBASize * 512
            msg(3) = 0
            drv_sendmessage(devaddr, 16, CPtr(Byte Ptr, @(msg(0))))

            Dim msgsize as Integer
            msgsize = 0
            While msgsize = 0
                showstring("-2")
                Yield
                showstring("+2")
                msgsize = drv_peekmessage
            Wend

            If msgsize <> 20 Then *cptr(Byte Ptr, &HED051000 + msgsize) = 0
            drv_readmessage(CPtr(Byte Ptr, @(msg(0))))

            showbyte(asc("["))
            showbyte(asc("P"))
            showbyte(asc(str$(count)))
            showbyte(asc("M"))
            showbyte(asc(str$(msg(1))))
            showbyte(asc("]"))

            msg(0) = BLOCKDRIVERCOMMAND_SETEXTENT
            msg(1) = 0
            msg(2) = msg(2) ' source maps to dest
            msg(3) = 0
            msg(4) = 0
            msg(5) = 0 ' destination map = 0
            msg(6) = CLng(LBAStart) * 512
            msg(7) = (CLng(LBAStart) * 512) SHR 32
            msg(8) = CLng(LBASize) * 512
            msg(9) = (CLng(LBASize) * 512) SHR 32
            
            showstring "map: " + str(msg(2)) + " 0x" + hex$(lbasize * 512) + "@ 0x" + hex$(lbastart * 512) + chr$(13) + chr$(10)
            
            drv_sendmessage(devaddr, 40, CPtr(Byte Ptr, @(msg(0))))

            Dim newpart as PARTITION Ptr
            partdata->partitioncount = partdata->partitioncount + 1
            newpart = Allocate(partdata->partitioncount * sizeof (PARTITION))
            If newpart <> CPtr(PARTITION Ptr, 0) Then
                ' copy existing entries
                For lp = 1 to partdata->partitioncount - 1
                    newpart[lp-1] = partdata->partitions[lp-1]
                Next lp
                ' fill in new entry
                newpart[partdata->partitioncount - 1].StartLocation = CLng(LBAStart) * 512
                newpart[partdata->partitioncount - 1].EndLocation = CLng(LBASize) * 512 + CLng(LBAStart) * 512 - 1
                newpart[partdata->partitioncount - 1].mapindex = msg(2)
                ' free unused stuff
                if partdata->partitions <> CPtr(PARTITION Ptr, 0) Then Deallocate(partdata->partitions)
                partdata->partitions = newpart
            End If

        End If

        count = count - 1
    Wend

End Sub

Sub Dospart_IndexToMapping(ByVal info As Byte Ptr, ByVal Sender As Integer, ByVal Index As Integer)

End Sub
