' Summary: fsprobe.bas
' Detects partitions and filesystems
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/block.bi"
#include "mos/file.bi"
#include "mos/devmgr.bi"
#include "mos.bi"
#include "x86.bi"

Type BlockdevInfo
    PhysDevId As Integer       ' physical storage medium ID
    PhysDevAddr As Integer     ' physical storage medium address (for caching)
    PhysMapping As Integer     ' view of storage medium
    Offset As Long             ' offset
    Size As Long               ' size = blocks * bytesperblock
    Blocks As Long             ' number of physical blocks
    BytesPerBlock As Integer   ' Bytes in a sector
    ParentDev As Integer       ' parent filesystem
    ParentTag As Integer       ' info provided by parent fs
End Type


' Partitioning systems
Declare Function ProbePCTab(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
Declare Function ProbePCGUID(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer

' Actual filesystems
Declare Function ProbeFAT(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
Declare Function ProbeSFS(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
Declare Function ProbeEXT2(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
Declare Function ProbeEXT3(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
Declare Function ProbeXFS(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
Declare Function Probe9660(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer

' Final detector
Declare Function ProbeAny(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer

Type DetectScript
    ProbeFunction As Function (ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
    Registername as String * 24
End Type

Type DeviceInfo
    devdata as BlockdevInfo
    devnumber as Integer
    checked as Integer
End Type

Dim Shared devices() As DeviceInfo
Dim Shared devcount As Integer

Dim Shared probelist() As DetectScript
Dim Shared probecount As Integer

Declare Sub ScheduleProbe(ByRef Devname As String, ByVal Probe as Function(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer)
Declare Sub ScheduleDevice(ByRef device As BlockdevInfo, ByVal devno As Integer)
Declare Sub GetDeviceInfo(ByVal Devaddr As Integer, ByVal Devid As Integer)
Declare Sub GetSegmentInfo(ByVal Devaddr As Integer, ByVal Devid As Integer)
Declare Function ReadDevblock(ByRef Device As BlockdevInfo, ByVal dataout as Unsigned Byte Ptr, ByVal block as Long) As Integer

Sub showbyte(ByVal b As Integer)
    outportb(&HE9, b)
End Sub

Sub showstring(ByRef s As String)
    Dim lp As Integer
    For lp = 0 to Len(s)
        showbyte(asc(mid$(s, lp, 1)))
    Next lp
End Sub


Sub modmain CDecl Alias "main" ()

    ' Init communication port
    drv_setname(DRIVER_BUS, 5)
    Yield

    Dim maxdev As Integer
    Dim validated() As Integer
    maxdev = 1
    redim validated(maxdev)

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HE9, 1)

    ' register FS detectors
    ScheduleProbe("FS DOSPART", @ProbePCTab)
    ScheduleProbe("FS VFAT", @ProbeFAT)
    ScheduleProbe("FS SFS", @ProbeSFS)
    ScheduleProbe("FS Unknown", @ProbeAny)

    ' loop while needed
    While 1 = 1

        ' Check newly found FSes
        Dim lp As Integer
        For lp = 1 to devcount
            If devices(lp).checked = 0 Then

                Dim status As Integer
                status = 0

                showstring "Starting FS probe..." + chr$(13) + chr$(10)
                ' Check if this filesystem is present
                Dim lp2 As Integer
                For lp2 = 1 to probecount
                    status = probelist(lp2).ProbeFunction(devices(lp).devdata, devices(lp).devnumber)
                    If status = 1 then Exit For
                Next lp2

                ' We found a filesystem
                If status = 1 Then
                    Dim message(0 to 1) As Integer
                    message(0) = DEVMGRCOMMANDS_ADD
                    message(1) = devices(lp).devnumber
                    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(message(0)) )  )

                    While drv_peekmessage() = 0
                        Yield
                    Wend

                    drv_readmessage(CPtr(Byte Ptr, @(message(0)) ) )

                    Dim ws As String
                    ws = "        " & probelist(lp2).RegisterName
                    Dim bp As Byte Ptr
                    bp = *Cptr(Byte Ptr Ptr, @ws)
                    Cptr(Integer Ptr, bp)[0] = DEVMGRCOMMANDS_SETNAME
                    Cptr(Integer Ptr, bp)[1] = message(0)
                    drv_sendmessage(DRIVER_MGR * &H10000, len(ws), bp)

                    ws = "        " & Str$(devices(lp).devdata.PhysDevID) & ":" & Str$(devices(lp).devdata.PhysMapping)
                    bp = *Cptr(Byte Ptr Ptr, @ws)
                    Cptr(Integer Ptr, bp)[0] = DEVMGRCOMMANDS_SETLOCATION
                    Cptr(Integer Ptr, bp)[1] = message(0)
                    drv_sendmessage(DRIVER_MGR * &H10000, len(ws), bp)


                Else
                    '*CPtr(Byte Ptr, &H10C4C000 + lp) = 0
                End If

                devices(lp).checked = 1
            End if
        Next lp
        Yield

        'outportb(&HE9, asc("-"))

        ' check for new block devices
        Dim done As Integer
        Dim drvindex As Integer
        done = 0
        drvindex = 1
        While Done = 0
            Yield

            If validated(drvindex) = 0 Then

                Dim msgdata() As Integer
                Redim msgdata(2)
                msgdata(0) = DEVMGRCOMMANDS_GETNAME
                msgdata(1) = drvindex
                drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msgdata(0))) )

                While drv_peekmessage() = 0
                    Yield
                Wend

                Dim rv As Integer
                rv = drv_peekmessage()

                If (rv > 1) Then
                    Dim rs As String
                    rs = space$(rv)
                    drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))

                    msgdata(0) = DEVMGRCOMMANDS_GETADDR
                    msgdata(1) = drvindex
                    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msgdata(0))) )
                    While drv_peekmessage() = 0
                        Yield
                    Wend
                    drv_readmessage( CPtr(Byte Ptr, @(msgdata(0))))

                    If msgdata(0) <> 0 Then
                        validated(drvindex) = 1

                        Dim devaddr As Integer
                        devaddr = msgdata(0)

                        ' query for the graphics2 interface
                        msgdata(0) = SYSCOMMAND_QUERYINTERFACES
                        if devaddr = &H20494350 Then *CPtr(Byte Ptr, &H0EF50001) = 0
                        drv_sendmessage(devaddr, 4, CPtr(Byte Ptr, @(msgdata(0))) )
                        While drv_peekmessage() = 0
                            Yield
                        Wend
                        rv = drv_peekmessage()
                        Redim msgdata((rv + 3) \ 4)
                        drv_readmessage(CPtr(Byte Ptr, @(msgdata(0))))

                        ' test if we can use it
                        Dim ok as Integer, lp as Integer
                        ok = 0
                        For lp = 0 To (rv \ 4) - 1
                            If msgdata(lp) = INTERFACE_BLOCK Then ok = ok Or 1
                            If msgdata(lp) = INTERFACE_FILESEGMENT Then ok = ok Or 2
                        Next lp
                        If (ok And 1) = 1 Then
                            ' register probe
                            Yield
                            GetDeviceInfo(devaddr, drvindex)
                        End If
                        If (ok And 2) = 2 Then
                            ' enumerate and register segments for probing
                            Yield
                            'Asm
                            '    xchg bx, bx
                            'End Asm
                            GetSegmentInfo(devaddr, drvindex)
                            '*Cptr(Byte Ptr, &HE560001) = 0
                        End If
                        drvindex = drvindex + 1
                    Else
                        ' try next device
                        drvindex = drvindex + 1
                    End If
                Else
                    Dim rs As String
                    rs = space$(rv)
                    drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))

                    ' all devices checked
                    drvindex = 1
                    done = 1
                End If
            Else
                ' device already checked
                drvindex = drvindex + 1
            End If

            If drvindex > maxdev Then
                maxdev = drvindex
                redim preserve validated(maxdev)
            End If
        Wend
    Wend
End Sub

Sub ScheduleProbe(ByRef Devname As String, ByVal Probe as Function(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer)
    probecount = probecount + 1
    Redim Preserve probelist(probecount)

    probelist(probecount).registername = devname
    probelist(probecount).probefunction = probe
End Sub

Sub ScheduleDevice(ByRef device As BlockdevInfo, ByVal devno As Integer)
    devcount = devcount + 1
    Redim Preserve devices(devcount)

    devices(devcount).devdata = device
    devices(devcount).devnumber = devno
    devices(devcount).checked = 0
End Sub

Sub GetDeviceInfo(ByVal Devaddr As Integer, ByVal Devid As Integer)
    ' Get device geometry
    Dim msgdata(0 to 4) as integer
    msgdata(0) = BLOCKDRIVERCOMMAND_GEOM
    drv_sendmessage(devaddr, 4, CPtr(Byte Ptr, @(msgdata(0))) )

    While drv_peekmessage() = 0
        Yield
    Wend
    drv_readmessage( CPtr(Byte Ptr, @(msgdata(0))))

    Dim info as BlockdevInfo
    info.PhysDevId = Devid
    info.PhysDevAddr = Devaddr
    info.PhysMapping = 0
    info.Offset = 0
    info.size = msgdata(1) * msgdata(2)
    info.blocks = msgdata(2)
    info.bytesperblock = msgdata(1)
    info.Parentdev = 0
    info.Parenttag = 0

    ScheduleDevice(info, devid)
End Sub

Sub GetSegmentInfo(ByVal Devaddr As Integer, ByVal Devid As Integer)

    ' Get segment count
    Dim msgdata(0 to 7) as Integer
    msgdata(0) = FILECOMMAND_SEGCOUNT
    drv_sendmessage(devaddr, 4, CPtr(Byte Ptr, @(msgdata(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    drv_readmessage( CPtr(Byte Ptr, @(msgdata(0))))

    Dim segcount As Integer
    Dim lp As Integer
    segcount = msgdata(1)
    For lp = 0 To segcount - 1
        msgdata(0) = FILECOMMAND_GETSEG
        msgdata(1) = lp
        drv_sendmessage(devaddr, 8, CPtr(Byte Ptr, @(msgdata(0))) )
        While drv_peekmessage() = 0
            Yield
        Wend
        drv_readmessage( CPtr(Byte Ptr, @(msgdata(0))))

        Dim info as BlockdevInfo
        info.PhysDevId = msgdata(2)
        info.PhysDevAddr = msgdata(3)
        info.PhysMapping = msgdata(4)

        showstring "New mapping: " + str$(info.PhysMapping) + ", id: " + str$(info.PhysDevId) + ", addr 0x" + hex$(info.PhysDevAddr) + chr$(13) + chr$(10)

        info.Offset = 0
        info.size = (CLng(msgdata(5)) And &H00000000FFFFFFFF&) + msgdata(6) SHL 32
        ' Fixme: go to storage medium and get info
        info.blocks = info.size \ 512
        info.bytesperblock = 512
        info.Parentdev = Devid
        info.Parenttag = 0

        ScheduleDevice(info, devid)

    Next lp
    showstring "Query complete" + chr$(13) + chr$(10)

End Sub

Function ProbePCTab(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
    Dim sector(0 to 511) as Unsigned Byte
    Function = 0

    If device.BytesPerBlock <> 512 Then Exit Function
    If device.Parentdev <> 0 Then Exit Function
    If device.Offset <> 0 Then Exit Function

    readdevblock(device, @sector(0), 0)

    if sector(&H01FE) <> &H55 Then Exit Function
    if sector(&H01FF) <> &HAA Then Exit Function

    Dim lp As Integer
    For lp = 0 to 3
        outportb(&HE9, Asc("0") + sector(446 + 16 * lp))
        if (sector(446 + 16 * lp) <> &H00) And (sector(446 + 16 * lp) <> &H80) Then Exit Function
    Next lp

    Function = 1

End Function


Function ReadDevblock(ByRef Device As BlockdevInfo, ByVal dataout as Unsigned Byte Ptr, ByVal block as Long) As Integer
    Dim msgdata(0 to 4) As Integer

    msgdata(0) = BLOCKDRIVERCOMMAND_READ  ' read
    msgdata(1) = device.PhysMapping ' map 0 (untranslated)
    msgdata(2) = block + Device.offset \ Device.BytesPerBlock             ' starting block
    msgdata(3) = 1                  ' block count
    drv_sendmessage(Device.PhysDevAddr, 16, CPtr(Byte Ptr, @(msgdata(0))) )

    showstring "Requesting block " + str$(block) + ", map " + str$(device.PhysMapping) + " from address 0x" + hex$(Device.PhysDevAddr) + chr$(13) + chr$(10)

    While drv_peekmessage() = 0
        Yield
    Wend

    Dim getbytes() As Byte
    redim getbytes(Device.BytesPerBlock+16)
    drv_readmessage(@getbytes(0))

    Dim lp as Integer
    For lp = 0 to Device.BytesPerBlock - 1
        dataout[lp] = getbytes(lp+16)
    Next lp

    'outportb(&HE9, Asc("0"))
    'outportb(&HE9, Asc("x"))
    'outportb(&HE9, Asc(mid$("0123456789ABCDEF", (getbytes(16+510) SHR 4) + 1, 1)))
    'outportb(&HE9, Asc(mid$("0123456789ABCDEF", (getbytes(16+510) and &HF) + 1, 1)))
    'outportb(&HE9, Asc(mid$("0123456789ABCDEF", (getbytes(16+511) SHR 4) + 1, 1)))
    'outportb(&HE9, Asc(mid$("0123456789ABCDEF", (getbytes(16+511) and &HF) + 1, 1)))
    'outportb(&HE9, Asc(" "))

    Function = 1
End Function

Function ProbeFAT(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
    Dim sector(0 to 511) as Unsigned Byte
    Function = 0

    If device.BytesPerBlock <> 512 Then Exit Function
    If device.Offset <> 0 Then Exit Function

    readdevblock(device, @sector(0), 0)

    if sector(&H0036) <> Asc("F") Then Exit Function
    if sector(&H0037) <> Asc("A") Then Exit Function
    if sector(&H0038) <> Asc("T") Then Exit Function

    Function = 1

End Function

Function ProbeSFS(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer
    Dim sector(0 to 511) as Unsigned Byte
    Function = 0

    If device.BytesPerBlock <> 512 Then Exit Function
    If device.Offset <> 0 Then Exit Function

    readdevblock(device, @sector(0), 0)

    if sector(&H01AC) <> Asc("S") Then Exit Function
    if sector(&H01AD) <> Asc("F") Then Exit Function
    if sector(&H01AE) <> Asc("S") Then Exit Function
    if sector(&H01AF) And &HF0 <> &H10 Then Exit Function ' require major version 1

    Function = 1

End Function

Function ProbeAny(ByRef device As BlockdevInfo, ByVal devnumber As Integer) As Integer

    Function = 1

End Function
