' Summary: roottrace.bas
' FS startup utility to locate the storage driver
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/drivercom.bi"
#include "mos.bi"
#include "mos/driver.bi"
#include "mos/devmgr.bi"

#include "roottrace.bi"

Function LocateStorage(ByVal currentid As Integer, Byref devidout As Integer, ByRef devaddrout As Integer) As Integer
    Function = 1

    Dim msg() As Integer
    Redim msg(2)
    Dim rv As Integer

    msg(0) = DEVMGRCOMMANDS_CONNECTIVITY
    msg(1) = currentid
    
    ' request connected nodes for device - the first one is the parent
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    Redim msg((drv_peekmessage() + 3) \ 4)
    drv_readmessage(CPtr(Byte Ptr, @(msg(0)) ) )
    If msg(0) <= 0 Then
        ' no connected nodes? should not happen
        Function = 1
        Exit Function
    End If

    Dim parentid as Integer
    parentid = msg(1)

    If parentid = 0 or parentid = currentid Then
         ' top of tree, no storage devices found.
         Function = 1
         Exit Function
    End If

    ' get the message address for the device
    msg(0) = DEVMGRCOMMANDS_GETADDR
    msg(1) = parentid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    drv_readmessage( CPtr(Byte Ptr, @(msg(0))))

    Dim parentaddr As Integer
    parentaddr = msg(0)

    If parentaddr = 0 Then
         ' unloaded driver
         Function = 1
         Exit Function
    End If
    
    msg(0) = SYSCOMMAND_QUERYINTERFACES
    drv_sendmessage(parentaddr, 4, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    rv = drv_peekmessage()
    Redim msg((rv + 3) \ 4)
    drv_readmessage(CPtr(Byte Ptr, @(msg(0))))

    ' test if we can use it
    Dim ok as Integer, lp as Integer
    ok = 0
    For lp = 0 To (rv \ 4) - 1
        If msg(lp) = INTERFACE_BLOCK Then
            Function = 0
            devaddrout = parentaddr
            devidout = parentid
            Exit Function
        End If
    Next lp    
    
    ' not found, recurse up
    Function = LocateStorage(parentid, devidout, devaddrout)

End Function

Function LocateParent(ByVal currentid As Integer, Byref devidout As Integer, ByRef devaddrout As Integer) As Integer
    Function = 1

    Dim msg() As Integer
    Redim msg(2)
    Dim rv As Integer

    msg(0) = DEVMGRCOMMANDS_CONNECTIVITY
    msg(1) = currentid
    ' request connected nodes for device
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    Redim msg((drv_peekmessage() + 3) \ 4)
    drv_readmessage(CPtr(Byte Ptr, @(msg(0)) ) )
    If msg(0) <= 0 Then
        ' no connected nodes? should not happen
        Function = 1
        Exit Function
    End If

    Dim parentid as Integer
    parentid = msg(1)

    If parentid = 0 Then
         ' top of tree, no storage devices found.
         Function = 1
         Exit Function
    End If

    msg(0) = DEVMGRCOMMANDS_GETADDR
    msg(1) = parentid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    drv_readmessage( CPtr(Byte Ptr, @(msg(0))))

    Dim parentaddr As Integer
    parentaddr = msg(0)

    If parentaddr = 0 Then
         ' unloaded driver
         Function = 1
         Exit Function
    End If

    Function = 0
    devidout = parentid
    devaddrout = devaddrout

End Function

Function GetStorage(ByVal currentid As Integer, Byref devidout As Integer, ByRef mappingout As Integer) As Integer
    
    Dim msg() As Integer
    Redim msg(2)
    Dim rv As Integer

    msg(0) = DEVMGRCOMMANDS_GETLOCATION
    msg(1) = currentid
    ' request node location
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    
    Dim rs As String
    
    rs = space$(drv_peekmessage())
    drv_readmessage(*CPtr(Byte Ptr Ptr, @rs) )
    If (len(rs) <= 3) Then
        ' no location? should not happen
        Function = 1
        Exit Function
    End If
    
    Dim splitpoint As Integer
    splitpoint = instr(rs, ":")
    If splitpoint <= 1 Then
        ' Location misformatted
        Function = 1
        Exit Function
    End If
    
    devidout = ValInt(Left$(rs, splitpoint - 1))
    mappingout = ValInt(Mid$(rs, splitpoint + 1))
    Function = 0
    
End Function