' Summary: simplesched.bas
' Basic I/O Scheduler
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "scheduler.bi"

Type SimpleSchedulerList
    req As Request
    nextitem As Byte Ptr
End Type

Type SimpleSchedulerData
    head As SimpleSchedulerList Ptr
    tail As SimpleSchedulerList Ptr
End Type

Function SimpleSchedulerCreate() As Scheduler
    Dim s As Scheduler
    
    Dim queue As SimpleSchedulerData Ptr
    queue = CPtr(SimpleSchedulerData Ptr, Allocate(SizeOf(SimpleSchedulerData)))
    queue->head = CPtr(SimpleSchedulerList Ptr, 0)
    queue->tail = CPtr(SimpleSchedulerList Ptr, 0)

    s.privatedata = CPtr(Byte Ptr, queue)
    s.Release = @SimpleSchedulerRelease
    s.AddRequest = @SimpleSchedulerAddRequest
    s.PopRequest = @SimpleSchedulerPopRequest
    s.PopRequestSingle = @SimpleSchedulerPopRequestSingle
    s.IsEmpty = @SimpleSchedulerIsEmpty
    Function = s
End Function

Sub SimpleSchedulerRelease(ByVal privatedata as Byte Ptr)
    Dim head As SimpleSchedulerList Ptr, temp As SimpleSchedulerList Ptr
    Dim queue As SimpleSchedulerData Ptr
    queue = CPtr(SimpleSchedulerData Ptr, privatedata)
    head = queue->head
    While head <> CPtr(SimpleSchedulerList Ptr, 0)
        temp = head
        head = CPtr(SimpleSchedulerList Ptr, head->nextitem)
        Deallocate temp
    Wend
End Sub

Sub SimpleSchedulerAddRequest(ByVal privatedata as Byte Ptr Ptr, ByRef req As Request)
    Dim queue As SimpleSchedulerData Ptr
    queue = *CPtr(SimpleSchedulerData Ptr Ptr, privatedata)

    ' new list item
    Dim tail As SimpleSchedulerList Ptr
    tail = Allocate(SizeOf(SimpleSchedulerList))
    tail->req = req
    tail->nextitem = CPtr(Byte Ptr, 0)

    If queue->tail = CPtr(SimpleSchedulerList Ptr, 0) Then
        ' insert into empty queue
        queue->tail = tail
        queue->head = tail
    Else
        queue->tail->nextitem = CPtr(Byte Ptr, tail)
        queue->tail = tail
    End If
End Sub

Function SimpleSchedulerPopRequest(ByVal privatedata as Byte Ptr Ptr) As Request
    Dim req As Request
    Dim queue As SimpleSchedulerData Ptr
    queue = *CPtr(SimpleSchedulerData Ptr Ptr, privatedata)
    
    If queue->head = CPtr(SimpleSchedulerList Ptr, 0) Then
        ' empty queue
        req.numblocks = 0
    Else
        Dim head As SimpleSchedulerList Ptr
        head = queue->head
        req = head->req
        queue->head = CPtr(SimpleSchedulerList Ptr, head->nextitem)
        If queue->head = CPtr(SimpleSchedulerList Ptr, 0) Then
            ' just emptied the queue
            queue->tail = queue->head
        End If
        Deallocate head
    End If
    Function = req
End Function

Function SimpleSchedulerPopRequestSingle(ByVal privatedata as Byte Ptr Ptr) As Request
    Dim req As Request
    Dim queue As SimpleSchedulerData Ptr
    queue = *CPtr(SimpleSchedulerData Ptr Ptr, privatedata)
    
    If queue->head = CPtr(SimpleSchedulerList Ptr, 0) Then
        ' empty queue
        req.numblocks = 0
    Else
        Dim head As SimpleSchedulerList Ptr
        head = queue->head
        req = head->req
        If req.numblocks <= 1 Then
            ' head contains only one block
            queue->head = CPtr(SimpleSchedulerList Ptr, head->nextitem)
            If queue->head = CPtr(SimpleSchedulerList Ptr, 0) Then
                ' just emptied the queue
                queue->tail = queue->head
            End If
            Deallocate head
        Else
            ' "split" the head request and return the first needed block
            head->req.numblocks = head->req.numblocks - 1
            head->req.block = head->req.block + 1
            req.numblocks = 1
        End If
    End If
    Function = req
End Function

Function SimpleSchedulerIsEmpty(ByVal privatedata as Byte Ptr Ptr) As Integer
    Dim queue As SimpleSchedulerData Ptr
    queue = *CPtr(SimpleSchedulerData Ptr Ptr, privatedata)
    
    Function = 0
    If queue->head = CPtr(SimpleSchedulerList Ptr, 0) Then
        Function = 1
    End If
End Function