' Summary: sys_kbdumper.bas
' Test module monitoring the keyboard and sending the output to a device
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

'$include once: 'mos.bi'
'$include once: 'x86.bi'
'$include once: 'mos/gfx.bi'

' Todo: documentation
' Todo: comments

Declare Function ReadKB () as Integer
Declare Sub ModMain CDecl Alias "main"()

Dim lastkey As Long

Sub ModMain CDecl Alias "main"()

    portalloc &H60, 2
    
    Dim gate As Long
    gate = 0
    While gate = 0
        gate = RouteFind(PORTNAME("GFX0"))
    Wend

    Dim callback As Sub()
    Dim aspace As Long
    aspace = gatelookup(gate, @callback)

    Dim x as long, x2 as long
    Dim y as long, y2 as long
    For x = 0 to 79
    For y = 0 to 49
        x2 = x
        y2 = y
        Call Localipccall (callback, MANGLE(GFX_SETPIXEL, gate), x2, y2, 0)
    Next y
    Next x

    Dim fiststage as Long

    firststage = 0

    While 1 = 1
        Dim key As Long
        Dim inout as Long
        inout = gate
        key = ReadKB()
        If firststage = 0 Then
            firststage = key
        Else
            Call Localipccall (callback, MANGLE(GFX_SETPIXEL, gate), firststage, key, &H7)
            firststage = 0
        End If
    Wend

End Sub

Function ReadKB () as Integer
    ' Y = &H15
    ' N = &H31
    Dim temp as Unsigned Byte
    Dim key as Unsigned Byte
    Dim breakexit as Unsigned Byte = 0
    Dim done as Unsigned Byte = 0
    Dim isescaped as Unsigned Byte = 0
    While done = 0
        key = inportb(&H60)
        temp = inportb(&H61)
        outportb(&H61,temp Or  &H80)    'disable
        outportb(&H61,temp And &H7F)    'and reenable
        If key = &HE0 Then
            isescaped = &H80
        ElseIf key > &H80 Then
            If key = breakexit Then
                done = 1
            Else
                breakexit = 0
                isescaped = 0
            End If
        Else
            breakexit = key or &H80
            ReadKB = key or isescaped
        End If
    Wend
End Function

' docs taken from http://www.win.tue.nl/~aeb/linux/kbd/scancodes.html

' keys (dutch)
'      +00 +01 +02 +03 +04 +05 +06 +07 +08 +09 +0A +0B +0C +0D +0E +0F
' 00 -     ESC  1   2   3   4   5   6   7   8   9   0  \/? ~ BSP TAB - 0F
' 10 -  Q   W   E   R   T   Y   U   I   O   P  ^  * | RET LCT  A   S  - 1F
' 20 -  D   F   G   H   J   K   L  +   ` @ LSH < >  Z   X   C   V  - 2F
' 30 -  B   N   M  , ; . : - = RSH N * LAL SPB CAP F1  F2  F3  F4  F5  - 3F
' 40 - F6  F7  F8  F9  F10 NUM SCR N-7 N-8 N-9 N - N-4 N-5 N-6 N + N-1 - 4F
' 50 - N-2 N-3 N-0 N .         [] F11 F12                             - 5F