' Summary: test_ati.bas
' Testing module for ATI graphics stuff
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

'$include once: 'vga_io.bi'
'$include once: 'mos.bi'
'$include once: 'x86.bi'
'$include once: 'mos/pci.bi'

Declare Sub ModMain Cdecl Alias "main" ()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
Declare Function GetYesNo () As Integer
Declare Function ReadKB () as Integer
Declare Sub ClearCon (vram As Byte Ptr)
Declare Function Mach64_PCIProbe(ByRef base_lfb As Long, ByRef base_aperture As Long, ByRef base_pio As Integer) As Long
Declare Sub TestATI (vram As Byte Ptr, cram As Byte Ptr)
Declare Sub RunATITest (vram As Byte Ptr, lfb As Byte Ptr, aperture As Long Ptr, portbase As Long)

Declare Sub ATI_LFBClearCon(lfb As Byte Ptr)
Declare Sub ATI_LFBClearDisplay(lfb As Byte Ptr, bytes As Long)
Declare Sub ATI_LFBPrintString (s As String, vram As Byte Ptr, offset As Integer)
Declare Sub ATI_LFBPackFont(src As Byte Ptr, dest As Byte Ptr)
Declare Sub ATI_LFBUnpackFont(src As Byte Ptr, dest As Byte Ptr)

Declare Sub PutPixel(vram As Byte Ptr, x As Long, y As Long, col As Long, bpp As Byte, pitch As Long)
Declare Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
Declare Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
Declare Sub WriteConioString(vram As Byte Ptr, s as String, font() As Byte, row As Long, column As Long, col As Long, bpp as Byte, vw As Long)
Declare Sub RenderTest(vram as Byte Ptr, w as long, h as long, bpp as byte, vw as long)

Declare Sub ATI_Setmode Cdecl Alias "ATI_Setmode" ()

Common Shared ATIMach64_101 As Long

Public Sub ModMain Cdecl Alias "main" ()
    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    Dim bios As Byte Ptr
    Dim vaddress as Byte Ptr

    vaddress = CPtr(Byte Ptr, &HA0000)
    vram = CPtr(Byte Ptr, &HA0000000)
    cram = CPtr(Byte Ptr, &HA0018000)
    bios = CPtr(Byte Ptr, &HA0020000)

    ' claim video memory
    memmap (64 * 1024 * 3) / 4096, vram, vaddress
    ' claim KBC
    portalloc &H60, 2
    ' claim VGA
    portalloc &H3C0, 32

    ClearCon cram
    PrintString "BASIC For teh win (>O.O)>", cram, 25 * 80 - 27

    PrintString "Welcome to the ATI test", cram, 0

    Dim signature As String
    Dim atiport As Integer
    Dim boardtype1 As Integer
    Dim boardtype2 As Integer
    Dim boardstring As String
    Dim lp As Long
    signature = ""
    For lp = 1 To 9
        signature = signature + Chr$(bios[&H30 + lp])
    Next lp
    If signature = "761295520" Then
        PrintString "ATI signature detected: " + signature, cram, 80

        atiport = CInt(bios[&H10]) + 256 * CInt(bios[&H11])
        PrintString "ATI base port index: " + Hex$(atiport), cram, 160

        boardtype1 = CInt(bios[&H40]) + 256 * CInt(bios[&H41])
        boardtype2 = bios[&H43]

        Select Case boardtype1

            Case Else
                boardstring = "Unknown (" + hex$(boardtype1) + ")"
        End Select
        PrintString "Board Type (#1): " + boardstring, cram, 240

        Select Case boardtype2

            Case &H20
                boardstring = "Mach64"
            Case &H31
                boardstring = "18800   (V3)"
            Case &H32
                boardstring = "18800-1 (V4/5)"
            Case &H33
                boardstring = "28800-2  VGA Wonder+ (V6)"
            Case &H34
                boardstring = "28800-4  VGA Wonder (1MB)"
            Case &H35
                boardstring = "28800-5  VGA Wonder 1MB/XL"
            Case &H36
                boardstring = "28800-6  VGA Wonder XL"

            Case &H3C
                boardstring = "3D Rage Pro"

            Case &H61
                boardstring = "68800    Mach-32"
            Case &H63
                boardstring = "68800    Mach-32"

            Case Else
                boardstring = "Unknown (" + hex$(boardtype2) + ")"
        End Select
        PrintString "Board Type (#2): " + boardstring, cram, 320
    Else

        PrintString "Invalid signature: " + signature + ", probably not an ATI card", cram, 80
    End If

    PrintString "Press Y to start the test at your hardware's peril", cram, 480
    PrintString "Press N to skip this test", cram, 560

    If GetYesNo() = 1 Then
        TestATI vram, cram
    End If
    'ClearCon cram

    ClearCon cram
    PrintString "Test Ended. Please hit the power or the reset button", cram, 0

    While 1 = 1

    Wend

End Sub

Public Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + 2 * offset] = ch
        vram[lp * 2 - 1 + 2 * offset] = 7
    Next lp

End Sub

Public Function GetYesNo () As Integer
    ' Y = &H15
    ' N = &H31

    Dim status As Integer = -1
    Dim key As Integer
    While status = -1
        key = ReadKB
        if key = &H15 then status = 1
        if key = &H31 then status = 0
    Wend
    GetYesNo = status
End Function

Public Function ReadKB () as Integer
    Dim temp as Unsigned Byte
    Dim key as Unsigned Byte
    Dim breakexit as Unsigned Byte = 0
    Dim done as Unsigned Byte = 0
    Dim isescaped as Unsigned Byte = 0
    While done = 0
        key = inportb(&H60)
        temp = inportb(&H61)
        outportb(&H61,temp Or  &H80)    'disable
        outportb(&H61,temp And &H7F)    'and reenable
        If key = &HE0 Then
            isescaped = &H80
        ElseIf key > &H80 Then
            If key = breakexit Then
                done = 1
            Else
                breakexit = 0
                isescaped = 0
            End If
        Else
            breakexit = key or &H80
            ReadKB = key or isescaped
        End If
    Wend
End Function

Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub

Public Function Mach64_PCIProbe(ByRef base_lfb As Long, ByRef base_aperture As Long, ByRef base_pio As Integer) As Long

    ' load returns
    base_lfb = 0
    base_aperture = 0
    base_pio = 0

    ' find the pci manager
    Dim gate As Long
    gate = RouteFind(PORTNAME("PCI0"))
    If gate = 0 then
        Mach64_PCIProbe = &HE2
        Exit Function
    End If

    ' get the entry point
    Dim callback As Sub()
    Dim aspace As Long
    aspace = gatelookup(gate, @callback)

    ' find an ATI card
    Dim arg1 As long
    Dim arg2 As long
    Dim arg3 As Long
    Dim pciaddr As Long
    Dim lp As Long
    arg2 = -1
    Mach64_PCIProbe = &HE1
    Do
        ' iterate devices
        arg1 = MANGLE(PCI_ENUMERATEDEV, gate)
        Call Localipccall (callback, arg1, arg2, arg3, 0)
        If arg1 <> -1 then
            If (arg1 and &HFFFF) = &H1002 Then
                ' we found an ati card, get BARs and determine lfb, mmio aperture and pio
                Mach64_PCIProbe = arg1
                pciaddr = arg2
                For lp = 0 to 5
                    arg1 = MANGLE(PCI_GETBARTYPE, gate)
                    arg2 = pciaddr
                    arg3 = lp
                    Call Localipccall (callback, arg1, arg2, arg3, 0)
                    If arg2 = 0 Then
                        ' unused BAR
                    ElseIf (arg2 and &H1) = 1 Then
                        ' port range
                        arg1 = MANGLE(PCI_GETBARBASE, gate)
                        arg2 = pciaddr
                        arg3 = lp
                        Call Localipccall (callback, arg1, arg2, arg3, 0)
                        base_pio = arg2 And &HFFFE
                    ElseIf (0 - arg2 <= 4096) Then
                        ' this seems to be the mmio aperture
                        arg1 = MANGLE(PCI_GETBARBASE, gate)
                        arg2 = pciaddr
                        arg3 = lp
                        Call Localipccall (callback, arg1, arg2, arg3, 0)
                        base_aperture = arg2
                    ElseIf (0 - arg2 > (1024& * 1024&)) Then
                        ' this seems to be the lfb
                        arg1 = MANGLE(PCI_GETBARBASE, gate)
                        arg2 = pciaddr
                        arg3 = lp
                        Call Localipccall (callback, arg1, arg2, arg3, 0)
                        base_lfb = arg2
                    Else
                        ' some memory range with unknown purpose - not a Mach64?
                    End If

                Next lp
                
                ' break from the loop
                arg1 = -1
            End if
        End If

    Loop While arg1 <> -1

End Function

' Function: TestATI
' tests for an ATI Mach64 and sets up the
'
Public Sub TestATI (vrambase As Byte Ptr, cram As Byte Ptr)
    Dim chiptype As Long
    Dim configreg As Long
    Dim p_lfb As Long, p_aper As Long, p_port As Integer, p_result As Long

    ATI_Setmode

    ClearCon(cram)

    ' probe PCI
    p_result = Mach64_PCIProbe(p_lfb, p_aper, p_port)
    PrintString "PCI Probe result: " & hex$(p_result), cram, 0
    PrintString "LFB offset: " & hex$(p_lfb), cram, 80
    PrintString "Aperture: " & hex$(p_aper), cram, 160
    PrintString "Port Range: " & hex$(p_port), cram, 240


    ' probe addresses
    chiptype = Peek(Long, @(vrambase[&H1FCE0]))
    PrintString "Ati config_chip_id value: " + Hex$(chiptype), cram, 320

    configreg = inportd(&H6AEC)
    PrintString "Ati config_ctrl value: " + Hex$(configreg), cram, 400


    ' Load the values and configure if necessary
    Dim lfb As Byte Ptr, real_lfb As Byte Ptr
    Dim aperture As Long Ptr, real_aperture As Long Ptr
    Dim portbase As Long

    If p_result > &HFFFF Then
        ' PCI probing found a card - use it
        real_lfb = CPtr(Byte Ptr, p_lfb)
        real_aperture = CPtr(Long Ptr, p_aper)
        portbase = p_port
        lfb = CPtr(Byte Ptr, &HB0000000)
        aperture = CPtr(Long Ptr, &HAE000000)
        ' map the LFB and aperture into the current address space
        memmap (4096& / 4096&), aperture, real_aperture
        memmap ((1024& * 1024& * 32&) / 4096&), lfb, real_lfb
        portalloc portbase, 1024
    Else
        ' TODO: find a non-pci Mach64 to test manual config of aperture + sparse portio
    End if

    If CLng(lfb) <> 0 And CLng(aperture) <> 0 then
        PrintString "The card has been prepared. Continue with the tests? (Y/N)", cram, 560
        If GetYesNo() Then
            RunATITest vrambase, lfb, aperture, portbase
        End if
    Else
        PrintString "The card couldn't be configured. Press a key to quit test.", cram, 560
        PrintString "If you do have a Mach64-based card, please file a bug report", cram, 640
        ReadKB()
    End If
End Sub


Sub ATI_LFBClearCon(lfb As Byte Ptr)
    Dim lp as long
    for lp = 0 to (80 * 25 * 4) - 1 step 4
        lfb[lp] = &H20
    next lp
End Sub

Sub ATI_LFBClearDisplay(lfb As Byte Ptr, bytes As Long)
    Dim lp as long
    For lp = 0 to bytes - 1
        lfb[lp] = &H0
    Next lp
End Sub


Sub ATI_LFBPrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 8 - 8 + 8 * offset] = ch
        vram[lp * 8 - 7 + 8 * offset] = 7
    Next lp
End Sub

Sub ATI_LFBPackFont(src As Byte Ptr, dest As Byte Ptr)
    Dim lp as long
    For lp = 0 to 8191
        dest[lp] = src[lp * 4 + 2]
    Next lp
End Sub

Sub ATI_LFBUnpackFont(src As Byte Ptr, dest As Byte Ptr)
    Dim lp as long
    For lp = 0 to 8191
        dest[lp * 4 + 2] = src[lp]
    Next lp
End Sub

Sub PutPixel(vram As Byte Ptr, x As Long, y As Long, col As Long, bpp As Byte, pitch As Long)
    Dim offset As Long
    Select case bpp
        Case 4
            Dim temp as Byte
            offset = x \ 2 + y * pitch
            If (x And &H1) = 1 Then
                temp = vram[offset] and &HF
                vram[offset] = temp + 16 * (col and &HF)
            Else
                temp = vram[offset] and &HF0
                vram[offset] = temp + (col and &HF)
            End If

        Case 8
            offset = x + y * pitch
            vram[offset] = CByte(col)

        Case 16
            offset = 2 * x + pitch
            Dim mempos as Short Ptr
            mempos = CPtr(Short Ptr, @vram[offset])
            mempos[0] = CShort(col)

        Case 32
            offset = 4 * x + pitch
            Dim mempos as Long Ptr
            mempos = CPtr(Long Ptr, @vram[offset])
            mempos[0] = col

    End Select
End Sub

Sub WriteConioString(vram As Byte Ptr, s as String, font() As Byte, row As Long, column As Long, col As Long, bpp as Byte, vw As Long)
    WriteGfxString vram, s, @font(0), column * 8, row * 16, col, bpp, vw
End Sub

Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
    Dim lp as long
    For lp = 1 to len(s)
        WriteGfxChar vram, asc(mid$(s,lp,1)), font, x + 8 * (lp - 1), y, col, bpp, vw
    next lp
End Sub
Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, bpp as Byte, vw as Long)
    dim lp as long
    Dim fontbyte as byte
    For lp = 0 to 15
        fontbyte = font[32 * ch + lp]
        if (fontbyte and &H01) = &H01 then PutPixel vram, x + 7, y + lp, col, bpp, vw
        if (fontbyte and &H02) = &H02 then PutPixel vram, x + 6, y + lp, col, bpp, vw
        if (fontbyte and &H04) = &H04 then PutPixel vram, x + 5, y + lp, col, bpp, vw
        if (fontbyte and &H08) = &H08 then PutPixel vram, x + 4, y + lp, col, bpp, vw
        if (fontbyte and &H10) = &H10 then PutPixel vram, x + 3, y + lp, col, bpp, vw
        if (fontbyte and &H20) = &H20 then PutPixel vram, x + 2, y + lp, col, bpp, vw
        if (fontbyte and &H40) = &H40 then PutPixel vram, x + 1, y + lp, col, bpp, vw
        if (fontbyte and &H80) = &H80 then PutPixel vram, x + 0, y + lp, col, bpp, vw
    Next lp
End Sub

Sub RenderTest(vram as Byte Ptr, w as long, h as long, bpp as byte, vw as long)
    Dim lpx as long, lpy as long
    For lpx = 1 To w - 1 Step 2
        PutPixel vram, lpx, 0, 9, bpp, vw
        PutPixel vram, lpx, 1, 9, bpp, vw
        If lpx mod 10 = 9 then
            PutPixel vram, lpx, 2, 9, bpp, vw
        End If
        If lpx mod 40 = 39 then
            PutPixel vram, lpx, 3, 9, bpp, vw
        End If
        PutPixel vram, lpx, h-1, 9, bpp, vw
        PutPixel vram, lpx, h-2, 9, bpp, vw
    Next lpx
    For lpy = 1 To h - 1 Step 2
        PutPixel vram, 0, lpy, 9, bpp, vw
        PutPixel vram, 1, lpy, 9, bpp, vw

        PutPixel vram, w-1, lpy, 9, bpp, vw
        PutPixel vram, w-2, lpy, 9, bpp, vw

        If lpy mod 10 = 9 then
            PutPixel vram, w-3, lpy, 9, bpp, vw
        End If
        If lpy mod 40 = 39 then
            PutPixel vram, w-4, lpy, 9, bpp, vw
        End If
    Next lpy
End Sub

Sub ATI_WritePLL(Portbase as Long, Index as Byte, Value as Byte)
    outportb(Portbase + &H91, Index * 4 + 2)
    outportb(Portbase + &H92, Value)
End Sub

Function ATI_ReadPLL(Portbase as Long, Index as Byte) As Byte
    outportb(Portbase + &H91, Index * 4)
    ATI_ReadPLL = inportb(Portbase + &H92)
End Function


' Function: RunATITest
' Runs the ATI Mach64 Test suite
'
Public Sub RunATITest (vram As Byte Ptr, lfb As Byte Ptr, aperture As Long Ptr, portbase As Long)

    Dim rl As Long
    Dim lp As Long
    Dim rb As Byte

    Dim fontdata() As Byte
    Dim refregs As Long Ptr

    ReDim fontdata(8192)

    ' Backup the font
    ATI_LFBPackFont(lfb, @fontdata(0))

    ' Load a graphics mode the VGA way
    VGAUnlockCRTC
    VGASet320x240Mode
    VGASetModeX
    VGAEnableDisplay

    ' Clear the LFB
    ATI_LFBClearDisplay(lfb, 640 * 480 * 2)

    ' Render the ruler
    RenderTest lfb, 640, 480, 8, 640

    refregs = @ATIMach64_101

'    rl = inportd(portbase + &H1C)
'    outportd(portbase + &H1C, rl And &HFDFFFFFF&)
'    rb = ATI_ReadPLL(portbase, &H5)
'    ATI_WritePLL(portbase, &H5, rb Or &H4)
'    ATI_WritePLL(portbase, &H5, rb)
'    For lp = 0 to 63
'        If lp * 4 <> &HC1 Then outportd(portbase + lp * 4, refregs[lp])
'    Next lp
'    rl = inportd(portbase + &H1C)
'    outportd(portbase + &H1C, refregs[&H1C \ 4])

    ' Ripped from the debugger
    'outportb(&Hbc91, &H34)
    'outportb(&Hbc91, &H2c)
    'outportb(&Hbc91, &H10)
    'outportb(&Hbc91, &H9b)
    'outportb(&Hbc92, &Hff)
    'outportb(&Hbc91, &H81)
    'outportb(&Hbc91, &Haf)
    'outportb(&Hbc92, &Hbf)
    'outportb(&Hbc91, &H81)
    'outportb(&Hbc91, &Ha7)
    'outportb(&Hbc92, &Hda)
    'outportb(&Hbc91, &H81)

    While (inportb(&H3DA) and &H8) = 0
        ' VSync
    Wend

    'outportb(&H3c0, &H20)
    'outportb(&Hbc86, &H8f)
    'outportb(&Hbc91, &H34)
    'outportb(&Hbc91, &H2c)
    'outportb(&Hbc91, &H10)
    'outportb(&Hbc1f, &Hfd)
    'outportb(&Hbc91, &H9b)
    'outportb(&Hbc92, &Hbf)
    'outportb(&Hbc91, &H81)
    'outportb(&Hbc91, &Haf)
    'outportb(&Hbc92, &Hff)
    'outportb(&Hbc91, &H81)
    'outportb(&Hbc91, &Hab)
    'outportb(&Hbc92, &Hea)
    'outportb(&Hbc91, &H81)
    'outportb(&Hbc1e, &Hbf)
    'outportw(&Hbc00, &H67)
    'outportb(&Hbc02, &H4f)
    'outportw(&Hbc04, &H258)
    'outportb(&Hbc06, &H27)
    'outportb(&Hbcfc, &Hf8)
    'outportw(&Hbc08, &H1fc)
    'outportw(&Hbc0a, &H1df)
    'outportw(&Hbc0c, &H1e0)
    'outportb(&Hbc0e, &H23)
    'outportb(&Hbc90, &H3)
    'outportb(&Hbc44, &H0)
    'outportb(&Hbc46, &H0)
    'outportb(&Hbc4a, &H0)
    'outportb(&Hbc48, &H0)
    'outportw(&Hbc40, &H0)
    'outportw(&Hbc42, &H0)
    'outportb(&Hbc1d, &H2)
    'outportb(&Hbc91, &H97)
    'outportb(&Hbc92, &Hf)
    'outportb(&Hbc91, &H81)
    'outportw(&Hbc20, &H45c)
    'outportb(&Hbc22, &H48)
    'outportw(&Hbc24, &H434)
    'outportw(&Hbc26, &H80)
    'outportb(&Hbc1c, &Hcc)
    'outportb(&Hbc86, &Hdf)
    'outportb(&Hbc85, &Hef)
    outportb(&Hbc1f, &H4b)
    outportb(&Hbc1f, &H49)
    outportb(&Hbc1f, &H4b)
    outportb(&Hbc1f, &H4b)
    'outportb(&Hbcc5, &H7f)
    'outportb(&Hbc86, &Hff)
    'outportb(&H3c2, &Heb)
    'outportb(&Hbcc5, &Hff)
    'outportb(&Hbc85, &Hf7)

    ' disable VGA frontend
    'rl = inportd(portbase + &HDC)
    'outportd(portbase + &HDC, rl or &H00000080&)

    ' Switch to Mach64 CRTC
    'rl = inportd(portbase + &H1C)
    'outportd(portbase + &H1C, rl or &H01000000&)

    ' Set vga_linear and cnt_en. Undocumented by svgadoc, always set by X driver
    'rl = inportd(portbase + &H1C)
    'outportd(portbase + &H1C, rl or &H48000000&)

    ' Set pitch
    'outportd(portbase + &H14, &H14000000&)

    ' Set horizontal timing
    'outportd(portbase + &H00, &H004F005F&)

    ' Disable memory boundary
    'rl = inportd(portbase + &HDC)
    'outportd(portbase + &HB0, rl And &HFFF0FFFF&)

    ' Switch to 15bpp
    'rl = inportd(portbase + &H1C)
    'outportd(portbase + &H1C, rl or &H00000300&)

    ' set cursor enable
    'rl = inportd(portbase + &HD0)
    'outportd(portbase + &HD0, rl or &H00080000&)

    ' move the cursor
    'outportd(portbase + &H6C, &H00640064)

    ' select cursor image
    'outportd(portbase + &H70, 0)
    'outportd(portbase + &H68, 0)

    ' set colors
    'outportd(portbase + &H60, &HFFFFFF0F)
    'outportd(portbase + &H64, &H40404001)

    ' overscan
    'outportd(portbase + &H40, &HFF000004)
    'outportd(portbase + &H44, &H00010001)
    'outportd(portbase + &H48, &H00080008)

    WriteConioString lfb, "Portmap Register Dump", fontdata(), 1, 1, 7, 8, 640

    Dim regno As Long
    Dim regcount As Long
    regno = 0
    regcount = 0
    While regno < 64 and regcount < 26
        rl = inportd(portbase + regno * 4)
        If rl <> refregs[regno] Then
            WriteConioString lfb, "M+" + hex$(regno * 4) + ": 0x" + hex$(rl) + ":" + hex$(refregs[regno]), fontdata(), regcount + 2, 18, 7, 8, 640
            regcount = regcount + 1
        End If
        regno = regno + 1
    Wend


    outportb(&Hbc1f, &H4b)
    ReadKB()

    outportb(&Hbc1f, &H5b)
    ReadKB()

    outportb(&Hbc1f, &H6b)
    ReadKB()

    outportb(&Hbc1f, &Hcb)
    ReadKB()

    outportb(&Hbc1f, &H4f)
    ReadKB()


    ' enable VGA frontend
    rl = inportd(portbase + &HDC)
    outportd(portbase + &HDC, rl And &HFFFFFF7F&)

    ' Switch to VGA CRTC
    rl = inportd(portbase + &H1C)
    outportd(portbase + &H1C, rl And &HFEFFFFFF&)

    ATI_LFBUnpackfont @fontdata(0), lfb
    ATI_LFBClearCon lfb

    VGAUnlockCrtc
    VGASetTextMode
    VGAEnableDisplay

    ' Restore pitch
    'outportd(portbase + &H14, &H0A000000&)

End Sub
