' Summary: test_blobs.bas
' A test module for the BLOBS system
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

' includes
'$include once: 'mos.bi'
'$include once: 'mos/gfx.bi'
'$include once: 'mos/blobs.bi'


' Function: ModMain
' contains the BLOBS sample program
'
' This program tests some basic functionality of BLOBS
' by printing a welcome message and showing some graphical
' artwork
'
' in:
'     none
'
' out:
'     none
'
Sub ModMain CDecl Alias "main" ()
    Dim gate As Long
    Dim viewportindex As Long
    Dim s As String

    ' our message
    s = "Welcome to MysticOS/BLOBS"

    ' get the first BLOBS host
    gate = 0
    While gate = 0
        gate = RouteFind(PORTNAME("UIS0"))
    Wend

    ' get the entry point
    Dim callback As Sub()
    Dim aspace As Long
    aspace = gatelookup(gate, @callback)

    ' create a window
    Dim rv as Long
    rv = MANGLE(BLOBS_CREATEWINDOW, gate)
    Call Localipccall (callback, rv, Len(s), 2, 0)
    ' and get the new port
    gate = rv
    aspace = gatelookup(gate, @callback)


    ' print the string
    Dim lp as Long
    For lp = 1 to Len(s)
        rv = MANGLE(BLOBS_PRINTCHAR, gate)
        Call Localipccall (callback, rv, Asc(Mid(s,lp,1)), 0, 0)
    Next lp

    ' do the artwork
    For lp = 1 to Len(s)
        rv = MANGLE(BLOBS_SETPIXEL, gate)
        Call Localipccall (callback, rv, lp - 1, (lp Mod 2) + 2, ((lp-1) Mod 7) + 1)
        Call Localipccall (callback, rv, lp - 1, ((lp + 1) Mod 2) + 2, 0)
    next lp

    While 1 = 1
    Wend
End Sub
