' Summary: test_gfx.bas
' Testing module for graphics stuff
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

'$lang: "deprecated"
'$include once: 'vga_io.bi'
'$include once: 'mos.bi'
'$include once: 'x86.bi'

Declare Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
Declare Sub ClearCon (vram As Byte Ptr)
Declare Sub ModMain Cdecl Alias "main" ()
Declare Function GetYesNo () As Integer
Declare Function ReadKB () as Integer

' VGA register accesses

' Higher Level Functions
Type RegisterType
    Port as Short
    Index as Byte
    Value as Byte
End Type
Declare Sub ReadRegs(regarray() As RegisterType)

' Test Helpers

' Test status
Declare Function ResultToString(v as Byte) As String
#define stat_passed 1
#define stat_skipped 0
#define stat_failed -1
Type ResultType
    GC_DecodeB0B7 As Byte
    GC_DecodeA0AF As Byte
    GC_DecodeA0BF As Byte
    CRTC_640x480x4P As Byte
    CRTC_320x200x8C As Byte
    CRTC_320x200x8U As Byte
    CRTC_320x240x8U As Byte
    CRTC_400x300x8U As Byte
    CRTC_virtwidth As Byte
    CRTC_doublescan As Byte
    SEQ_Chain4_a As Byte
    SEQ_Chain4_b As Byte
    SEQ_Chain4_c As Byte
    SEQ_Chain4_d As Byte
    SEQ_Chain4_e As Byte
    SEQ_Chain4_f As Byte
    SEQ_Chain4_g As Byte

    SEQ_Dword_256 As Byte
    SEQ_Word_256 As Byte
    SEQ_Byte_256 As Byte
    SEQ_Dword_64 As Byte
    SEQ_Word_64 As Byte
    SEQ_Byte_64 As Byte
End Type

' Graphics Routines
Enum VideoModes
    ' standard addressing modes
    linear = 1      ' linear mode
    unchained = 2   ' planar 256 color
    planar = 3      ' planar 16 color

    ' tweaked addressing modes
    halfchained = 4 ' planar 256 color in word mode
    chained = 5     ' emulating linear mode with chain-4 bit clear (planar 256 in dword mode)
    planar2 = 6     ' 16 color in word mode
    planar4 = 7     ' 16 color in dword mode
    concatl = 8     ' concatenated 16 color mode on a left-handed system
    concatr = 9     ' concatenated 16 color mode on a right-handed system
End Enum
Declare Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode as byte, vw as long)
Declare Sub RenderTest(vram as Byte Ptr, w as long, h as long, mode as byte, vw as long)
Declare Sub ClearLinear(vram as Byte Ptr)
Declare Sub ClearUnchained(vram as Byte Ptr, pixels as long)
Declare Function PlaneSelect(planeno as long) as byte
Declare Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, mode as Byte, vw as Long)
Declare Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, mode as Byte, vw as Long)

' Test Groups
Declare Sub TestVGA(vram as Byte Ptr, cram as Byte Ptr)
Declare Sub TestCRTC(vram as Byte Ptr, cram as Byte Ptr)

' Individual tests
Declare Sub TestMemDecodeRegB0(q as ResultType, vram as Byte Ptr, cram as Byte Ptr)
Declare Sub TestMemDecodeRegA0(q as ResultType, vram as Byte Ptr, cram as Byte Ptr)
Declare Sub TestMemDecodeRegAB(q as ResultType, vram as Byte Ptr, cram as Byte Ptr)
Declare Sub TestHW640x480P(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
Declare Sub TestHW320x200C(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
Declare Sub TestHW320x200U(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
Declare Sub TestHW320x240U(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
Declare Sub TestHW400x300U(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
Declare Sub TestDoubleScan(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
Declare Sub TestVirtualWidth(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)

Declare Sub TestChain4Behaviour_1(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestChain4Behaviour_2(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestChain4Behaviour_3(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestChain4Behaviour_4(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestChain4Behaviour_5(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestChain4Behaviour_6(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestChain4Behaviour_7(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)

' These test dword/word/byte mode
Declare Sub TestMemsizeBehaviour_D(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestMemsizeBehaviour_W(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestMemsizeBehaviour_B(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestMemsizeBehaviour_D16(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestMemsizeBehaviour_W16(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestMemsizeBehaviour_B16(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)

' Some real VGA trickery...
Declare Sub TestConcatenatedMode_L(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
Declare Sub TestConcatenatedMode_R(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)

' workaround for incomplete libfb
Declare Function malloc Cdecl Alias "malloc" (byval bytes as long) as Byte Ptr
Declare Sub free Cdecl Alias "free" (byval pointer as Byte Ptr)

Public Sub ModMain Cdecl Alias "main" ()
    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    Dim vaddress as Byte Ptr

    vaddress = CPtr(Byte Ptr, &HA0000)
    vram = CPtr(Byte Ptr, &HA0000000)
    cram = CPtr(Byte Ptr, &HA0018000)

    ' claim video memory
    memmap (64 * 1024 * 2) / 4096, vram, vaddress
    ' claim KBC
    portalloc &H60, 2
    ' claim VGA
    portalloc &H3C0, 32

    ClearCon cram
    PrintString "BASIC For teh win (>O.O)>", cram, 25 * 80 - 27

    PrintString "Welcome to the MOS graphics test module", cram, 0
    PrintString "Press Y to start the VGA compatibility test at your hardware's peril", cram, 80
    PrintString "Press N to skip this test", cram, 160

    If GetYesNo() = 1 Then
        TestVGA vram, cram
    End If

    ClearCon cram

    PrintString "Welcome to the MOS graphics test module", cram, 0
    PrintString "Press Y to start the CRTC test suite at your hardware's peril", cram, 80
    PrintString "Press N to halt the computer", cram, 160
    If GetYesNo() = 1 Then
        TestCRTC vram, cram
    End If

    ClearCon cram
    PrintString "Test Ended. Please hit the power or the reset button", cram, 0

    While 1 = 1

    Wend

End Sub

Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub

Public Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + 2 * offset] = ch
        vram[lp * 2 - 1 + 2 * offset] = 7
    Next lp

End Sub

Public Function GetYesNo () As Integer
    Dim status As Integer = -1
    Dim key As Integer
    While status = -1
        key = ReadKB
        if key = &H15 then status = 1
        if key = &H31 then status = 0
    Wend
    GetYesNo = status
End Function

Public Function ReadKB () as Integer
    ' Y = &H15
    ' N = &H31
    Dim temp as Unsigned Byte
    Dim key as Unsigned Byte
    Dim breakexit as Unsigned Byte = 0
    Dim done as Unsigned Byte = 0
    Dim isescaped as Unsigned Byte = 0
    While done = 0
        key = inportb(&H60)
        temp = inportb(&H61)
        outportb(&H61,temp Or  &H80)    'disable
        outportb(&H61,temp And &H7F)    'and reenable
        If key = &HE0 Then
            isescaped = &H80
        ElseIf key > &H80 Then
            If key = breakexit Then
                done = 1
            Else
                breakexit = 0
                isescaped = 0
            End If
        Else
            breakexit = key or &H80
            ReadKB = key or isescaped
        End If
    Wend
End Function

Sub ReadRegs(regarray() As RegisterType)
    regarray(0).port = &H3C0
    regarray(0).index = &H10
    regarray(0).value = Read3C0(&H10)

    regarray(1).port = &H3C0
    regarray(1).index = &H11
    regarray(1).value = Read3C0(&H11)

    regarray(2).port = &H3C0
    regarray(2).index = &H12
    regarray(2).value = Read3C0(&H12)

    regarray(3).port = &H3C0
    regarray(3).index = &H13
    regarray(3).value = Read3C0(&H13)

    regarray(4).port = &H3C0
    regarray(4).index = &H14
    regarray(4).value = Read3C0(&H14)

    regarray(5).port = &H3C2
    regarray(5).index = 0
    regarray(5).value = Read3C2

    regarray(6).port = &H3C2
    regarray(6).index = 0
    regarray(6).value = Read3C2

    regarray(7).port = &H3C4
    regarray(7).index = 1
    regarray(7).value = Read3C4(1)

    regarray(8).port = &H3C4
    regarray(8).index = 3
    regarray(8).value = Read3C4(3)

    regarray(9).port = &H3C4
    regarray(9).index = 4
    regarray(9).value = Read3C4(4)

    regarray(10).port = &H3CE
    regarray(10).index = 5
    regarray(10).value = Read3CE(5)

    regarray(11).port = &H3CE
    regarray(11).index = 6
    regarray(11).value = Read3CE(6)

    regarray(12).port = &H3D4
    regarray(12).index = 0
    regarray(12).value = Read3D4(0)

    regarray(13).port = &H3D4
    regarray(13).index = 1
    regarray(13).value = Read3D4(1)

    regarray(14).port = &H3D4
    regarray(14).index = 2
    regarray(14).value = Read3D4(2)

    regarray(15).port = &H3D4
    regarray(15).index = 3
    regarray(15).value = Read3D4(3)

    regarray(16).port = &H3D4
    regarray(16).index = 4
    regarray(16).value = Read3D4(4)

    regarray(17).port = &H3D4
    regarray(17).index = 5
    regarray(17).value = Read3D4(5)

    regarray(18).port = &H3D4
    regarray(18).index = 6
    regarray(18).value = Read3D4(6)

    regarray(19).port = &H3D4
    regarray(19).index = 7
    regarray(19).value = Read3D4(7)

    regarray(20).port = &H3D4
    regarray(20).index = 8
    regarray(20).value = Read3D4(8)

    regarray(21).port = &H3D4
    regarray(21).index = 9
    regarray(21).value = Read3D4(9)

    regarray(22).port = &H3D4
    regarray(22).index = &H10
    regarray(22).value = Read3D4(&H10)

    regarray(23).port = &H3D4
    regarray(23).index = &H11
    regarray(23).value = Read3D4(&H11)

    regarray(24).port = &H3D4
    regarray(24).index = &H12
    regarray(24).value = Read3D4(&H12)

    regarray(25).port = &H3D4
    regarray(25).index = &H13
    regarray(25).value = Read3D4(&H13)

    regarray(26).port = &H3D4
    regarray(26).index = &H14
    regarray(26).value = Read3D4(&H14)

    regarray(27).port = &H3D4
    regarray(27).index = &H15
    regarray(27).value = Read3D4(&H15)

    regarray(28).port = &H3D4
    regarray(28).index = &H16
    regarray(28).value = Read3D4(&H16)

    regarray(29).port = &H3D4
    regarray(29).index = &H17
    regarray(29).value = Read3D4(&H17)

' ports added to before-image to work around setmodex calls
    regarray(30).port = &H3C4
    regarray(30).index = 2
    regarray(30).value = Read3C4(2)

' ports added to before-image to restore read mode
    regarray(31).port = &H3CE
    regarray(31).index = 4
    regarray(31).value = Read3CE(4)


    VGAEnableDisplay
End Sub

Sub Writeregs(regarray() As RegisterType)
    Dim lp as Long
    VGAUnlockCRTC
    For lp = 0 To 31 Step 1
        Select Case regarray(lp).port
            Case &H3C0
                Write3C0(regarray(lp).index, regarray(lp).value)
            Case &H3C2
                Write3C2 regarray(lp).value
            Case &H3C4
                Write3C4(regarray(lp).index, regarray(lp).value)
            Case &H3CE
                Write3CE(regarray(lp).index, regarray(lp).value)
            Case &H3D4
                Write3D4(regarray(lp).index, regarray(lp).value)

        End Select
    Next lp
    VGAEnableDisplay
End Sub

Sub ReadFont(vram as byte ptr, dumper as byte ptr, regs() as RegisterType)
    dim lp as long
    VGASet320x200mode
    VGASetModeX
    Write3CE &H4, &H2
    for lp = 0 to 8191
        dumper[lp] = vram[lp]
    next lp
    WriteRegs regs()
End Sub
Sub WriteFont(vram as byte ptr, dumper as byte ptr, regs() as RegisterType)
    Dim lp As Long
    VGASet320x200mode
    VGASetModeX
    Write3C4 &H2, &H4
    For lp = 0 to 8191
        vram[lp] = dumper[lp]
    Next lp
    WriteRegs regs()
End Sub

Function ResultToString(v as Byte) As String
    If v = stat_passed Then
        ResultToString = "Pass"
    ElseIf v = stat_failed Then
        ResultToString = "Fail"
    Else
        ResultToString = "Skipped"
    End If
End Function

Sub TestVGA(vram as Byte Ptr, cram as Byte Ptr)

    Dim result As ResultType

    PrintString "In the next sequence of tests, the output capabilities of the card", cram, 80
    PrintString "are tested. For each screen, we ask you to either press the Y or N", cram, 160
    PrintString "button depending on wether you can see the output correctly.", cram, 240

    PrintString "In most cases you'll see either 'Hit Y' or 'Hit N' appear on the screen", cram, 320
    PrintString "If neither of these messages appears within a few seconds, we ask you", cram, 400
    PrintString "to press the N button. ", cram, 480
    PrintString "Some screens might show both messages. Should that happen, pick the", cram, 560
    PrintString "one that is visible best.", cram, 640

    PrintString "Press Y to perform these tests, or N to skip", cram, 800

    If GetYesNo() = 1 Then
        ClearCon cram

        Dim oldregs(0 to 31) As RegisterType
        Dim oldcharset as Byte Ptr
        oldcharset = malloc(8192)

        ReadRegs oldregs()


        TestMemDecodeRegB0 result, vram, cram
        TestMemDecodeRegA0 result, vram, cram
        TestMemDecodeRegAB result, vram, cram

        VGASet320x200Mode
        VGASetModeX

        ' store the font for gfx tests
        ReadFont vram, oldcharset, oldregs()

        VGASet320x200Mode
        VGASetModeX
        ClearUnchained vram, 256*256*4

        ' test for a VGA compatible CRTC
        TestHW320x200C result, vram, oldregs(), oldcharset
        TestHW320x200U result, vram, oldregs(), oldcharset
        TestHW320x240U result, vram, oldregs(), oldcharset
        TestHW400x300U result, vram, oldregs(), oldcharset
        TestHW640x480P result, vram, oldregs(), oldcharset
        If result.CRTC_320x200x8U = stat_passed Then
           TestDoubleScan result, vram, oldregs(), oldcharset
           TestVirtualWidth result, vram, oldregs(), oldcharset

           TestChain4Behaviour_1 result, vram, oldregs(), oldcharset
           TestChain4Behaviour_2 result, vram, oldregs(), oldcharset
           TestChain4Behaviour_3 result, vram, oldregs(), oldcharset
           TestChain4Behaviour_4 result, vram, oldregs(), oldcharset
           TestChain4Behaviour_5 result, vram, oldregs(), oldcharset
           TestChain4Behaviour_6 result, vram, oldregs(), oldcharset
           TestChain4Behaviour_7 result, vram, oldregs(), oldcharset

           'TestMemsizeBehaviour_D result, vram, oldregs(), oldcharset
           'TestMemsizeBehaviour_W result, vram, oldregs(), oldcharset
           'TestMemsizeBehaviour_B result, vram, oldregs(), oldcharset
           'TestMemsizeBehaviour_D16 result, vram, oldregs(), oldcharset
           'TestMemsizeBehaviour_W16 result, vram, oldregs(), oldcharset
           'TestMemsizeBehaviour_B16 result, vram, oldregs(), oldcharset
           TestConcatenatedMode_L result, vram, oldregs(), oldcharset
           TestConcatenatedMode_R result, vram, oldregs(), oldcharset

        End If

        WriteFont vram, oldcharset, oldregs()

        WriteRegs oldregs()
        'VGASetTextMode()
        'VGAEnableDisplay()

        free oldcharset
    End If

    ClearCon cram
    PrintString "Test results:", cram, 0
    PrintString "Decoding B0000-B7FFF in alpha mode:", cram, 80
    PrintString "Decoding A0000-AFFFF in alpha mode:", cram, 160
    PrintString "Decoding A0000-BFFFF in alpha mode:", cram, 240
    PrintString ResultToString(result.GC_DecodeB0B7), cram,  80 + 60
    PrintString ResultToString(result.GC_DecodeA0AF), cram, 160 + 60
    PrintString ResultToString(result.GC_DecodeA0BF), cram, 240 + 60

    PrintString "320x200x256 Chained mode:", cram, 320
    PrintString "320x200x256 Unchained mode:", cram, 400
    PrintString "320x240x256 Unchained mode:", cram, 480
    PrintString "400x300x256 Unchained mode:", cram, 560
    PrintString "640x460x16  Planar mode:", cram, 640
    PrintString ResultToString(result.CRTC_320x200x8C), cram, 320 + 60
    PrintString ResultToString(result.CRTC_320x200x8U), cram, 400 + 60
    PrintString ResultToString(result.CRTC_320x240x8U), cram, 480 + 60
    PrintString ResultToString(result.CRTC_400x300x8U), cram, 560 + 60
    PrintString ResultToString(result.CRTC_640x480x4P), cram, 640 + 60

    PrintString "Virtual Width Setting:", cram, 720
    PrintString "Doublescanning Support in graphics mode:", cram, 800
    PrintString ResultToString(result.CRTC_virtwidth),  cram, 720 + 60
    PrintString ResultToString(result.CRTC_doublescan), cram, 800 + 60

    PrintString "Chain4 Hybrid 1:", cram, 880
    PrintString "Chain4 Hybrid 2:", cram, 960
    PrintString "Chain4 Video Independence:", cram, 1040
    PrintString "Chain4 Memory Independence:", cram, 1120

    PrintString "Odd/Even Memory Independence:", cram, 1200
    PrintString "Odd/Even Video Independence:", cram, 1280

    PrintString ResultToString(result.SEQ_Chain4_a),  cram, 880 + 60
    PrintString ResultToString(result.SEQ_Chain4_b), cram, 960 + 60
    PrintString ResultToString(result.SEQ_Chain4_c), cram, 1040 + 60
    PrintString ResultToString(result.SEQ_Chain4_d), cram, 1120 + 60
    PrintString ResultToString(result.SEQ_Chain4_c), cram, 1200 + 60
    PrintString ResultToString(result.SEQ_Chain4_d), cram, 1280 + 60

    ReadKB

End Sub

Sub TestCRTC(vram as Byte Ptr, cram as Byte Ptr)
    ClearCon cram

    Dim valarray(0 to 13) as Long
    Dim entry as long
    Dim keypress As Long
    Dim s as string

    PrintString "CRTC Test utility", cram, 0
    PrintString "Use arrows to modify, ENTER to test, ESC to exit", cram, 80

    PrintString "Horizontal Resolution: <640 > pixels", cram, 240
    PrintString "Left Overscan Size:     8     dot clocks", cram, 320
    PrintString "Right Overscan Size:    8     dot clocks", cram, 400
    PrintString "Left Blank Size:        16    dot clocks", cram, 480
    PrintString "Right Blank Size:       32    dot clocks", cram, 560
    PrintString "HSync Period:           96    dot clocks", cram, 640
    PrintString "Vertical Resolution:    480   pixels", cram, 720
    PrintString "Top Overscan Size:      8     scanlines", cram, 800
    PrintString "Bottom Overscan Size:   8     scanlines", cram, 880
    PrintString "Top Blank Size:         24    scanlines", cram, 960
    PrintString "Bottom Blank Size:      2     scanlines", cram, 1040
    PrintString "VSync Period:           2     scanline clocks", cram, 1120
    PrintString "Virtual Width:          640   pixels", cram, 1200
    PrintString "Dot Clock:              25    MHz", cram, 1280

    entry = 0

    ' Horizontal timings for standard 640x480 mode
    valarray(0) = 640
    valarray(1) = 8
    valarray(2) = 8
    valarray(3) = 16
    valarray(4) = 32
    valarray(5) = 96
    ' Vertical timings for standard 640x480 mode
    valarray(6) = 480
    valarray(7) = 8
    valarray(8) = 8
    valarray(9) = 24
    valarray(10) = 2
    valarray(11) = 2
    valarray(12) = 640
    valarray(13) = 25

    While keypress <> 1
        keypress = ReadKB
        Select Case keypress
            Case 28
                Dim oldregs(0 to 31) As RegisterType
                Dim oldcharset as Byte Ptr
                oldcharset = malloc(8192)
                Dim vsave() As Byte
                redim vsave(4000)
                Dim x as Long

                For x = 0 to 3999
                    vsave(x) = cram[x]
                Next x
                ReadRegs oldregs()
                ReadFont vram, oldcharset, oldregs()

                ' pre-load 16 color mode registers
                VGAUnlockCRTC
                VGASet640x480x16Mode

                '
                VGAUnlockCRTC
                Dim htotal As Long
                Dim hclocks As Long
                Dim hdispend As Long
                Dim hblankstart As Long
                Dim hblankend As Long
                Dim hsyncstart As Long
                Dim hsyncend As Long
                
                Dim vtotal As Long
                Dim vdispend As Long
                Dim vblankstart As Long
                Dim vblankend As Long
                Dim vsyncstart As Long
                Dim vsyncend As Long
                
                Dim overflowregister As Long
                Dim scanlineregister As Long

                Dim offset As Long
                Dim clock As Long

                ' compute parameter values for horizontal timings
                hclocks = (valarray(0) + valarray(1) + valarray(2) + valarray(3) + valarray(4) + valarray(5)) \ 8
                htotal = hclocks - 5
                hdispend = valarray(0) \ 8 - 1
                hblankstart = (valarray(0) + valarray(2)) \ 8 - 1
                hsyncstart = (valarray(0) + valarray(2) + valarray(4)) \ 8 - 1
                hsyncend = (valarray(0) + valarray(2) + valarray(4) + valarray(5)) \ 8 - 1
                hblankend = (valarray(0) + valarray(2) + valarray(4) + valarray(5) + valarray(3)) \ 8 - 1
                hsyncend = (hsyncend Mod (hclocks - 1)) And &H1F
                hblankend = (hblankend Mod (hclocks - 1)) And &H3F
                ' compute parameter values for vertical timings
                vtotal = valarray(6) + valarray(7) + valarray(8) + valarray(9) + valarray(10) + valarray(11) - 1
                vdispend = valarray(6) - 1
                vblankstart = valarray(6) + valarray(8) - 1
                vsyncstart = valarray(6) + valarray(8) + valarray(10) - 1
                vsyncend = valarray(6) + valarray(8) + valarray(10) + valarray(11) - 1
                vblankend = valarray(6) + valarray(8) + valarray(10) + valarray(11) + valarray(9) - 1
                ' compute miscellaneous parameters
                offset = valarray(12) \ 16
                clock = 0
                if valarray(13) = 28 then clock = 4

                ' prepare registers, mangle and pack to VGA register format
                '   hsyncend register: 7 = HBE5 6..5 = reserved 4..0 = hsyncend
                if hblankend >= &H20 then hsyncend = hsyncend or &H80
                '   hblankend register: 7 = reserved(1) 6..5 = skew(0) 4..0 = hblankend
                hblankend = (hblankend And &H1F) or &H80 ' drop bits, add reserved bit
                '   clock select bits in miscellaneous output register
                clock = (Read3C2 and &HF3) or clock ' mask with existing contents
                '   overflow register: contains bits 8/9 of several other registers
                overflowregister = Read3D4(7) and &H10  ' mask off the bits we are adjusting
                if (vtotal and &H100) = &H100      then overflowregister = overflowregister + &H01
                if (vdispend and &H100) = &H100    then overflowregister = overflowregister + &H02
                if (vsyncstart and &H100) = &H100  then overflowregister = overflowregister + &H04
                if (vblankstart and &H100) = &H100 then overflowregister = overflowregister + &H08
                if (vtotal and &H200) = &H200      then overflowregister = overflowregister + &H20
                if (vdispend and &H200) = &H200    then overflowregister = overflowregister + &H40
                if (vsyncstart and &H200) = &H200  then overflowregister = overflowregister + &H80
                '   max scan line register: contains bit 9 of vertical blank start register
                scanlineregister = Read3D4(9) and &HDF
                if (vblankstart and &H200) = &H200 then scanlineregister = scanlineregister + &H20
                '   vertical retrace end: contains memory control and crtc protect
                vsyncend = (read3D4(&H11) and &HF0) or CByte(vsyncend and &H0F)



                ' write horizontal timing registers
                Write3D4 &H0, CByte(htotal)
                Write3D4 &H1, CByte(hdispend)
                Write3D4 &H2, CByte(hblankstart)
                Write3D4 &H3, CByte(hblankend)
                Write3D4 &H4, CByte(hsyncstart)
                Write3D4 &H5, CByte(hsyncend)
                ' ... and vertical timing
                Write3D4 &H6, CByte(vtotal)
                Write3D4 &H7, CByte(overflowregister)
                Write3D4 &H9, CByte(scanlineregister)
                Write3D4 &H10, CByte(vsyncstart)
                Write3D4 &H11, CByte(vsyncend)
                Write3D4 &H12, CByte(vdispend)
                Write3D4 &H15, CByte(vblankstart)
                Write3D4 &H16, CByte(vblankend)
                ' ... and miscellaneous registers
                Write3D4 &H13, CByte(offset)
                Write3C2 CByte(clock)
                ' ... and make the overscan visible (DAC index 3h)
                Write3C0 &H11, &H3

                ' Wait for the monitor to desync
                Dim delay as Long
                delay = GetTimerTicks + 100
                While GetTimerTicks < delay
                Wend

                ' take the VGA online, draw test screen
                VGAEnableDisplay
                ClearUnchained vram, 256*256*4
                RenderTest vram, valarray(0), valarray(6), VideoModes.planar, valarray(12)
                WriteGfxString vram, "Press any key", oldcharset, 20, 20, 15, VideoModes.planar, valarray(12)

                ' Wait for input
                ReadKB

                ' Restore the VGA to its original settings
                WriteFont vram, oldcharset, oldregs()
                WriteRegs oldregs()
                free oldcharset
                For x = 0 to 3999
                    cram[x] = vsave(x)
                Next x


            Case 200
                PrintString " ", cram, 80 * entry + 263
                PrintString " ", cram, 80 * entry + 268
                entry = entry - 1
                if entry = -1 then entry = 13
                PrintString "<", cram, 80 * entry + 263
                PrintString ">", cram, 80 * entry + 268
            Case 203
                Select Case Entry
                    Case 6 To 11
                        If valarray(entry) > 0 then valarray(entry) = valarray(entry) - 1
                    Case 12
                        If valarray(entry) >= 16 then valarray(entry) = valarray(entry) - 16
                    Case 13
                        if valarray(entry) = 28 then valarray(entry) = 25
                    Case Else
                        If valarray(entry) >= 8 then valarray(entry) = valarray(entry) - 8
                End Select

                s = str(valarray(entry))
                if len(s) = 1 then s = s + " "
                if len(s) = 2 then s = s + " "
                if len(s) = 3 then s = s + " "
                PrintString s, cram, 80 * entry + 264
            Case 205
                Select Case Entry
                    Case 6 To 11
                        If valarray(entry) <= 1022 then valarray(entry) = valarray(entry) + 1
                    Case 12
                        If valarray(entry) <= 2040 then valarray(entry) = valarray(entry) + 16
                    Case 13
                        if valarray(entry) = 25 then valarray(entry) = 28
                    Case Else
                        If valarray(entry) <= 2040 then valarray(entry) = valarray(entry) + 8
                End Select

                s = str(valarray(entry))
                if len(s) = 1 then s = s + " "
                if len(s) = 2 then s = s + " "
                if len(s) = 3 then s = s + " "
                PrintString s, cram, 80 * entry + 264
            Case 208
                PrintString " ", cram, 80 * entry + 263
                PrintString " ", cram, 80 * entry + 268
                entry = entry + 1
                if entry = 14 then entry = 0
                PrintString "<", cram, 80 * entry + 263
                PrintString ">", cram, 80 * entry + 268


            Case Else
                Printstring str(keypress), cram, 77
        End Select
    Wend

End Sub



Sub TestMemDecodeRegB0(q as ResultType, vram as Byte Ptr, cram as Byte Ptr)
    Dim b as Byte, v as Byte
    b = Read3CE(&H06)
    v = cram[0]
    Write3CE(&H06, (b And &HF3) + &H08)
    vram[&H10000] = Not v
    Write3CE(&H06, b)
    If cram[0] = v Then
        q.GC_DecodeB0B7 = stat_failed
    Else
        q.GC_DecodeB0B7 = stat_passed
        cram[0] = v
    End if
End Sub

Sub TestMemDecodeRegA0(q as ResultType, vram as Byte Ptr, cram as Byte Ptr)
    Dim b as Byte, v as Byte
    b = Read3CE(&H06)
    v = cram[0]
    Write3CE(&H06, (b And &HF3) + &H04)
    vram[0] = Not v
    Write3CE(&H06, b)
    If cram[0] = v Then
        q.GC_DecodeA0AF = stat_failed
    Else
        q.GC_DecodeA0AF = stat_passed
        cram[0] = v
    End if
End Sub
Sub TestMemDecodeRegAB(q as ResultType, vram as Byte Ptr, cram as Byte Ptr)
    Dim b as Byte, v as Byte
    b = Read3CE(&H06)
    v = cram[0]
    Write3CE(&H06, (b And &HF3) + &H00)
    vram[0] = Not v
    Write3CE(&H06, b)
    If cram[0] = v Then
        q.GC_DecodeA0BF = stat_failed
    Else
        q.GC_DecodeA0BF = stat_passed
        cram[0] = v
    End if
End Sub


Sub TestHW320x200C(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode    
    VGAEnableDisplay
    ClearLinear vram
    RenderTest vram, 320, 200, VideoModes.linear, 320
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.linear, 320
    Dim v as integer
    v = GetYesNo()
    q.CRTC_320x200x8C = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestHW640x480P(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet640x480x16Mode
    VGAEnableDisplay
    ClearUnchained vram, 640*480\2
    RenderTest vram, 640, 480, VideoModes.planar, 640
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.planar, 640
    Dim v as integer
    v = GetYesNo()
    q.CRTC_640x480x4P = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestHW320x200U(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.unchained, 320
    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.CRTC_320x200x8U = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestHW320x240U(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x240Mode
    VGASetModeX
    ClearUnchained vram, 320*240
    RenderTest vram, 320, 240, VideoModes.unchained, 320
    WriteGfxString vram, "Press [Y]", charset, 20, 200, 15, VideoModes.unchained, 320
    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.CRTC_320x240x8U = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestHW400x300U(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet400x300Mode
    VGASetModeX
    ClearUnchained vram, 400*300
    RenderTest vram, 400, 300, VideoModes.unchained, 400
    WriteGfxString vram, "Press [Y]", charset, 20, 250, 15, VideoModes.unchained, 400
    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.CRTC_400x300x8U = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestDoubleScan(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    Write3D4 9, (Read3D4(9) Or &H80)
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 100, VideoModes.unchained, 320
    WriteGfxString vram, "Press [Y]", charset, 20, 50,   8, VideoModes.unchained, 320
    WriteGfxString vram, "Press [N]", charset, 20, 150, 15, VideoModes.unchained, 320
    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.CRTC_doublescan = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestVirtualWidth(q as ResultType, vram as Byte Ptr, r() as RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    Write3D4 &H13, &H2D
    ClearUnchained vram, 360*200
    RenderTest vram, 320, 200, VideoModes.unchained, 360
    WriteGfxString vram, "Press [Y]", charset, 20, 50,  15, VideoModes.unchained, 360
    WriteGfxString vram, "Press [N]", charset, 20, 150, 15, VideoModes.unchained, 320
    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.CRTC_virtwidth = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestChain4Behaviour_1(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320

    Write3C4 &H4, &H0e
    Write3C4 &H2, &H01
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.linear, 320
    Write3C4 &H4, &H06

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Chain4_a = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestChain4Behaviour_2(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320

    Write3C4 &H4, &H0E
    Write3C4 &H2, &H0F
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.linear, 320
    Write3C4 &H4, &H06

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Chain4_b = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestChain4Behaviour_3(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320

    Write3C4 &H4, &H0E
    Write3C4 &H2, &H01
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.linear, 320

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Chain4_c = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestChain4Behaviour_4(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320

    Write3C4 &H4, &H0E
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.unchained, 320
    Write3C4 &H4, &H06

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Chain4_d = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestChain4Behaviour_5(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320

    Write3C4 &H4, &H02
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.unchained, 320
    Write3C4 &H4, &H06

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Chain4_e = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestChain4Behaviour_6(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320

    Write3C4 &H4, &H02
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.unchained, 320
    Write3C4 &H4, &H06

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Chain4_f = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestChain4Behaviour_7(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 320*200
    RenderTest vram, 320, 200, VideoModes.unchained, 320

    Write3C4 &H4, &H02
    Write3C4 &H2, &H0F
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.linear, 320
    Write3C4 &H4, &H06

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Chain4_g = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestMemsizeBehaviour_D(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 256*256*4

    Write3D4 &H17, Read3D4(&H17) and &HBF
    Write3D4 &H14, Read3D4(&H14) or &H40

    Write3C4 &H2, &HF
    WriteGfxString vram, "Press [N]", charset, 20, 20, 15, VideoModes.unchained, 320

    RenderTest vram, 320, 200, VideoModes.chained, 320
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.chained, 320


    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Dword_256 = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestMemsizeBehaviour_W(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 256*256*4

    Write3D4 &H17, Read3D4(&H17) and &HBF
    Write3D4 &H14, Read3D4(&H14) and &HBF

    RenderTest vram, 320, 200, VideoModes.halfchained, 320
    WriteGfxString vram, "Press [Y]", charset, 20, 180, 15, VideoModes.halfchained, 320
    WriteGfxString vram, "Press [N]", charset, 20, 20, 15, VideoModes.unchained, 320

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Word_256 = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestMemsizeBehaviour_B(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet320x200Mode
    VGASetModeX
    ClearUnchained vram, 256*256*4

    Write3D4 &H17, Read3D4(&H17) or &H40
    Write3D4 &H14, Read3D4(&H14) and &HBF

    RenderTest vram, 320, 200, VideoModes.unchained, 320
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.unchained, 320

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Byte_256 = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestMemsizeBehaviour_D16(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet640x480x16Mode
    ClearUnchained vram, 256*256*4

    Write3D4 &H17, Read3D4(&H17) and &HBF
    Write3D4 &H14, Read3D4(&H14) or &H40

    'RenderTest vram, 640, 480, VideoModes.planar4, 640
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.planar4, 640
    WriteGfxString vram, "Press [N]", charset, 20, 20, 15, VideoModes.planar, 640

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Dword_64 = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestMemsizeBehaviour_W16(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet640x480x16Mode
    ClearUnchained vram, 256*256*4

    Write3D4 &H17, Read3D4(&H17) and &HBF
    Write3D4 &H14, Read3D4(&H14) and &HBF

    'RenderTest vram, 640, 480, VideoModes.planar2, 640
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.planar2, 640
    WriteGfxString vram, "Press [N]", charset, 20, 20, 15, VideoModes.planar, 640

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Word_64 = (2 * v) - 1
    Writeregs r()
End Sub

Sub TestMemsizeBehaviour_B16(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet640x480x16Mode
    ClearUnchained vram, 256*256*4

    Write3D4 &H17, Read3D4(&H17) or &H40
    Write3D4 &H14, Read3D4(&H14) and &HBF

    RenderTest vram, 640, 480, VideoModes.planar, 640
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.planar, 640

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    q.SEQ_Byte_64 = (2 * v) - 1
    Writeregs r()
End Sub


' Concatenated Mode. Invention of mine. 
' Basically, it reorders 16-bit mode to pack 2 pixels in one byte
' instead of 8 pixels spread over 4 bytes.
'
' Try enabling Chain-4 and enjoy a linear 16-color mode. If only it werent limited to 640x240 -_-
'
Sub TestConcatenatedMode_L(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet640x480x16Mode
    ClearUnchained vram, 256*256*4

    ' set 256-shift mode
    Write3CE &H5, Read3CE(&H5) or &H40
    ' ah, an bit that IMO the best doc doesnt document. Enjoy the DAC Mask Register
    ' yup, its unsupported on qemu -_-
    Write3C6 &H0F

    Write3C0 &H11, &H07

    RenderTest vram, 640, 480, VideoModes.concatl, 640
    WriteGfxString vram, "Press [Y]", charset, 20, 20, 15, VideoModes.concatl, 640
    WriteGfxString vram, "Press [N]", charset, 20, 40, 15, VideoModes.planar, 640
    WriteGfxString vram, "Press [N]", charset, 20, 60, 15, VideoModes.concatr, 640

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    'q.SEQ_Byte_64 = (2 * v) - 1
    Writeregs r()
    
    Write3C6 &HFF
End Sub

Sub TestConcatenatedMode_R(q as ResultType, vram as Byte Ptr, r() As RegisterType, charset as Byte Ptr)
    VGAUnlockCRTC
    VGASet640x480x16Mode
    ClearUnchained vram, 256*256*4

    ' set 256-shift mode
    Write3CE &H5, Read3CE(&H5) or &H40
    ' and set the DAC mask -
    Write3C6 &HF0
    ' enable overscan (for test purposes)
    Write3C0 &H11, &H70

    RenderTest vram, 640, 480, VideoModes.concatr, 640
    WriteGfxString vram, "Press [N]", charset, 20, 20, 15, VideoModes.concatl, 640
    WriteGfxString vram, "Press [N]", charset, 20, 40, 15, VideoModes.planar, 640
    WriteGfxString vram, "Press [Y]", charset, 20, 60, 15, VideoModes.concatr, 640

    VGAEnableDisplay
    Dim v as integer
    v = GetYesNo()
    'q.SEQ_Byte_64 = (2 * v) - 1
    Writeregs r()
    
    Write3C6 &HFF
End Sub

Sub ClearLinear(vram as Byte Ptr)
    Dim lp as long
    for lp = 0 to &HFFFF
        vram[lp] = 0
    next lp
End Sub

Sub ClearUnchained(vram as Byte Ptr, pixels as long)
    Dim lp as long
    Write3C4 &H2, &HF
    for lp = 0 to (pixels \ 4) - 1
        vram[lp] = 0
    next lp
End Sub

Sub RenderTest(vram as Byte Ptr, w as long, h as long, mode as byte, vw as long)
    Dim lpx as long, lpy as long
    For lpx = 1 To w - 1 Step 2
        PutPixel vram, lpx, 0, 9, mode, vw
        PutPixel vram, lpx, 1, 9, mode, vw

        PutPixel vram, lpx, h-1, 9, mode, vw
        PutPixel vram, lpx, h-2, 9, mode, vw
    Next lpx
    For lpy = 1 To h - 1 Step 2
        PutPixel vram, 0, lpy, 9, mode, vw
        PutPixel vram, 1, lpy, 9, mode, vw

        PutPixel vram, w-1, lpy, 9, mode, vw
        PutPixel vram, w-2, lpy, 9, mode, vw
    Next lpy
End Sub

Sub PutPixel(vram as Byte Ptr, x as long, y as long, col as long, mode As Byte, vw As Long)
    Select Case mode
        Case VideoModes.linear
            vram[x + vw * y] = col And &HFF
        Case VideoModes.unchained
            Write3C4 &H2, PlaneSelect(x Mod 4)
            vram[(x + vw * y) \ 4] = col And &HFF
        Case VideoModes.halfchained
            Write3C4 &H2, PlaneSelect(x Mod 4)
            vram[((x + vw * y) \ 2) And &HFFFFFFFE] = col And &HFF
        Case VideoModes.chained
            Write3C4 &H2, PlaneSelect(x Mod 4)
            vram[(x + vw * y) And &HFFFFFFFC] = col And &HFF

        Case VideoModes.planar
            Dim setbyte as Byte
            Dim clearbyte as Byte
            Dim address as Long
            setbyte = PlaneSelect(7-(x Mod 8))
            clearbyte = 255 - setbyte
            address = (x + vw * y) \ 8
            Write3C4 &H2, 1
            Write3CE &H4, 0
            if (col and 1) = 1 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 2
            Write3CE &H4, 1
            if (col and 2) = 2 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 4
            Write3CE &H4, 2
            if (col and 4) = 4 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
            Write3C4 &H2, 8
            Write3CE &H4, 3
            if (col and 8) = 8 then
                vram[address] = vram[address] or setbyte
            else
                vram[address] = vram[address] and clearbyte
            end if
        case VideoModes.planar2
            PutPixel vram, (x and &H7) + 2 * (x And &HFFF8), y, col, VideoModes.planar, vw * 2
        case VideoModes.planar4
            PutPixel vram, (x and &H7) + 4 * (x And &HFFF8), y, col, VideoModes.planar, vw * 4

        case VideoModes.concatl
            Dim readbyte as byte
            Write3CE &H4, (x \ 2) Mod 4
            Write3C4 &H2, PlaneSelect((x \ 2) Mod 4)
            readbyte = vram[(x + vw * y) \ 8]
            if (x and 1) = 1 then
                readbyte = (readbyte and &HF0) or (col and &H0F)
            else
                readbyte = (readbyte and &H0F) or ((col * 16) and &HF0)
            end if
            vram[(x + vw * y) \ 8] = readbyte

        case VideoModes.concatr
            PutPixel vram, x xor 1, y, col, Videomodes.concatl, vw

    End Select
End Sub

Function PlaneSelect(planeno as long) as byte
    Select Case planeno
        Case 0
            PlaneSelect = 1
        Case 1
            PlaneSelect = 2
        Case 2
            PlaneSelect = 4
        Case 3
            PlaneSelect = 8
        Case 4
            PlaneSelect = 16
        Case 5
            PlaneSelect = 32
        Case 6
            PlaneSelect = 64
        Case 7
            PlaneSelect = &H80
    End Select
End Function

Sub WriteGfxString(vram as Byte Ptr, s as String, font as Byte Ptr, x as long, y as long, col as long, mode as Byte, vw as Long)
    Dim lp as long
    For lp = 1 to len(s)
        WriteGfxChar vram, asc(mid$(s,lp,1)), font, x + 8 * (lp - 1), y, col, mode, vw
    next lp
End Sub
Sub WriteGfxChar(vram as Byte Ptr, ch as Integer, font as Byte Ptr, x as long, y as long, col as long, mode as Byte, vw as Long)
    dim lp as long
    Dim fontbyte as byte
    For lp = 0 to 15
        fontbyte = font[32 * ch + lp]
        if (fontbyte and &H01) = &H01 then PutPixel vram, x + 7, y + lp, col, mode, vw
        if (fontbyte and &H02) = &H02 then PutPixel vram, x + 6, y + lp, col, mode, vw
        if (fontbyte and &H04) = &H04 then PutPixel vram, x + 5, y + lp, col, mode, vw
        if (fontbyte and &H08) = &H08 then PutPixel vram, x + 4, y + lp, col, mode, vw
        if (fontbyte and &H10) = &H10 then PutPixel vram, x + 3, y + lp, col, mode, vw
        if (fontbyte and &H20) = &H20 then PutPixel vram, x + 2, y + lp, col, mode, vw
        if (fontbyte and &H40) = &H40 then PutPixel vram, x + 1, y + lp, col, mode, vw
        if (fontbyte and &H80) = &H80 then PutPixel vram, x + 0, y + lp, col, mode, vw
    Next lp
End Sub
