' Summary: test_kbd.bas
' A test module for the BLOBS system
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

' includes
'$include once: 'mos.bi'
'$include once: 'mos/input.bi'
'$include once: 'mos/blobs.bi'


' Function: ModMain
' contains the BLOBS sample program
'
' This program tests some basic functionality of BLOBS
' by printing a welcome message and showing some graphical
' artwork
'
' in:
'     none
'
' out:
'     none
'
Sub ModMain CDecl Alias "main" ()
    Dim gate As Long
    Dim rv as Long
    Dim s As String

    ' our message
    s = "Keyboard Test" + chr$(13) + chr$(10)

    ' get the first BLOBS host
    gate = 0
    While gate = 0
        gate = RouteFind(PORTNAME("UIS0"))
    Wend

    ' get the entry point
    Dim blobscallback As Sub()
    Dim blobsgate As Long
    Dim aspace As Long
    aspace = gatelookup(gate, @blobscallback)

    ' create a window
    rv = MANGLE(BLOBS_CREATEWINDOW, gate)
    Call Localipccall (blobscallback, rv, 16, 10, 0)
    ' and get the new port
    gate = rv
    blobsgate = rv
    aspace = gatelookup(blobsgate, @blobscallback)

    ' print the string
    Dim lp as Long
    lp = 1

    For lp = 1 to Len(s)
        rv = MANGLE(BLOBS_PRINTCHAR, blobsgate)
        Call Localipccall (blobscallback, rv, Asc(Mid(s,lp,1)), 0, 0)
    Next lp

    ' clear another part of the screen
    For lp = 0 to 256
        rv = MANGLE(BLOBS_SETPIXEL, blobsgate)
        Call Localipccall (blobscallback, rv, lp and &HF, (lp and &HF0) \ 16 + 2, 0)
    Next lp

    ' get the first input device
    gate = 0
    While gate = 0
        gate = RouteFind(PORTNAME("INP0"))
    Wend

    ' get the entry point
    Dim inputcallback As Sub()
    Dim inputgate As Long
    aspace = gatelookup(gate, @inputcallback)
    inputgate = gate

    Dim lastevent As Long
    Dim currentevent As Long
    Dim val1 as long
    Dim button As Long
    Dim state as long

    rv = MANGLE(INPUT_GETEVENTCOUNT, inputgate)
    val1 = 0
    Call localipccall (inputcallback, rv, val1, 0, 0)
    lastevent = val1

    val1 = 0
    button = 0
    state = 0
    While 1 = 1

        val1 = 0
        rv = MANGLE(INPUT_GETEVENTCOUNT, inputgate)
        Call localipccall (inputcallback, rv, val1, 0, 0)
        currentevent = val1

        while lastevent < currentevent
            rv = MANGLE(INPUT_GETEVENT, inputgate)
            val1 = lastevent
            state = 1
            Call localipccall (inputcallback, rv, val1, state, 0)
            button = val1
            state = rv

            rv = MANGLE(BLOBS_SETPIXEL, blobsgate)
            val1 = state
            Call Localipccall (blobscallback, rv, button and &HF, ((button And &HF0) \ 16) + 2, val1)

            lastevent = lastevent + 1
        wend

        s = str(currentevent) + "," + str(button) + "," + str(state) + "  "

        For lp = 1 to Len(s)
            rv = MANGLE(BLOBS_SETCHAR, blobsgate)
            Call Localipccall (blobscallback, rv, lp - 1, 9, Asc(Mid(s,lp,1)))
        Next lp

    Wend

End Sub
