

'$include once: 'mos.bi'
'$include once: 'x86.bi'
'$include once: 'mos/pci.bi'

Declare Sub ModMain CDecl Alias "main"()
Declare Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
Declare Sub ClearCon (vram As Byte Ptr)

Sub ModMain CDecl Alias "main"()

    Dim cram As Byte Ptr
    Dim vaddress as Byte Ptr

    vaddress = CPtr(Byte Ptr, &HB8000)
    cram = CPtr(Byte Ptr, &HA0018000)

    ' claim video memory
    memmap (64 * 1024) / 4096, cram, vaddress

    ClearCon cram

    Printstring "PCI manager...trying", cram, 0

    ' find the pci manager
    Dim gate As Long
    gate = 0
    While gate = 0
        gate = RouteFind(PORTNAME("PCI0"))
    Wend

    Printstring "PCI manager: connected", cram, 0

    ' get the entry point
    Dim callback As Sub()
    Dim aspace As Long
    aspace = gatelookup(gate, @callback)

    Dim devloop As Long
    Dim devmax As Long
    Dim lineno As Long
    Dim arg1 As Long, arg2 As Long, cachedev As Long, cacheslot as long, arg3 As Long
    'devmax = 32 * 8
    'lineno = 160
    'devloop = 0
    'while devloop < devmax
    '    arg1 = MANGLE(PCI_READDWORD, gate)
    '    arg2 = devloop * 256 ' << shift to device
    '    Call Localipccall (callback, arg1, arg2, 0, 0)
    '
    '    if arg2 <> 0 And arg2 <> -1 then
    '        if devloop mod 8 = 0 or arg2 <> cachedev Then
    '            PrintString "PCI Device @" + hex$(devloop) + ": " & Hex$(arg2), cram, lineno
    '            lineno = lineno + 80
    '            cacheslot = devloop
    '        end if
    '
    '        devloop = devloop + 1
    '        devmax = (devloop and &HFF00) + 64 * 8
    '        cachedev = arg2
    '    else
    '        devloop = (devloop and &HFFF8) + 8
    '    end if
    'Wend
    
    devloop = -1
    cachedev = 0
    arg1 = 0
    do
        arg1 = MANGLE(PCI_ENUMERATEDEV, gate)
        Call Localipccall (callback, arg1, devloop, arg3, 0)
        if arg1 <> -1 then
            cacheslot = devloop
            cachedev = arg1
            PrintString "PCI Device @" + hex$(cacheslot) + ": " & Hex$(cachedev), cram, lineno
            lineno = lineno + 80
        end if
    loop while arg1 <> -1

    if lineno mod 160 > 0 then lineno = lineno + 80

    PrintString "PCI enumeration completed" , cram, lineno

    lineno = lineno + 160
    PrintString "Dumping PCI device @" + Hex$(cacheslot) + " (" + Str$((cacheslot and &HFF00) \ 256) + ":" + Str$((cacheslot and &HF8) \ 8) + ":" + Str$(cacheslot mod 8) + "): " + hex$(cachedev), cram, lineno

    lineno = lineno + 160
    Dim barbase as long, bartype as long
    for devloop = 0 to 5
        arg1 = MANGLE(PCI_GETBARBASE, gate)
        arg2 = cacheslot
        arg3 = devloop
        Call Localipccall (callback, arg1, arg2, arg3, 0)
        barbase = arg2

        arg1 = MANGLE(PCI_GETBARTYPE, gate)
        arg2 = cacheslot
        arg3 = devloop
        Call Localipccall (callback, arg1, arg2, arg3, 0)
        bartype = arg2

        PrintString "BAR #" + Str$(devloop) + ": 0x" + hex$(bartype) + " @ 0x" + hex$(barbase), cram, lineno
        lineno = lineno + 80
    next devloop

    While 1 = 1
    Wend

End Sub


' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Public Sub PrintString (s As String, vram As Byte Ptr, offset as long = 0)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + offset] = ch
        vram[lp * 2 - 1 + offset] = 7
    Next lp
End Sub


Public Sub ClearCon (vram As Byte Ptr)
    Dim lp As Long
    For lp = 1 to 80 * 25 * 2
        vram[2 * lp - 2] = 0
        vram[2 * lp - 1] = 7
    Next lp
End Sub