' Summary: test_poly.bas
' Small test performing zero-overdraw polygon rendering
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

'$include once: 'mos.bi'
'$include once: 'vga_io.bi'

Option Explicit

Declare Sub Main CDecl Alias "main" ()

Declare Sub PutPixel (vram as Byte Ptr, x As Long, y As Long, c as Byte)
Declare Function PlaneSelect(planeno As Long) As Byte
Declare Sub Triangle(vram As Byte Ptr, x1 As Long, y1 As Long, x2 As Long, y2 As Long, x3 As Long, y3 As Long, c as Byte)

Sub Main CDecl Alias "main" ()

    Dim vram As Byte Ptr
    Dim cram As Byte Ptr
    Dim vaddress as Byte Ptr

    vaddress = CPtr(Byte Ptr, &HA0000)
    vram = CPtr(Byte Ptr, &HA0000000)

    ' claim VGA
    memmap (64 * 1024 * 2) / 4096, vram, vaddress
    portalloc &H3C0, 32

    Call VGAUnlockCRTC()
    Call VGASet320x240Mode()
    Call VGASetModeX()
    Call VGAEnableDisplay()

    Dim lpx As Long, lpy As Long
    Write3C4 &H2, 15
    For lpx = 0 to 320 * 240 \ 4
        vram[lpx] = 0
    Next lpx


' positions:
'          90,10
'  20,50             180, 60
'          80,80
'  30,90             170, 80
'          120,190

    ' draw a irregular hexagon, to test slopes
    Triangle vram,  80, 80, 20, 50, 90, 10, 8
    Triangle vram,  80, 80, 90, 10,180, 60, 9
    Triangle vram,  80, 80,180, 60,170, 80, 10
    Triangle vram,  80, 80,170, 80,120,190, 11
    Triangle vram,  80, 80,120,190, 30, 90, 12
    Triangle vram,  80, 80, 30, 90, 20, 50, 13

    ' draw an diamond, to test correct rendering of flat edges
    Triangle vram,  80, 80, 60, 80, 80, 60, 3
    Triangle vram,  80, 80, 60, 80, 80,100, 4
    Triangle vram,  80, 80,100, 80, 80, 60, 5
    Triangle vram,  80, 80,100, 80, 80,100, 6

    While 1 = 1

    Wend

End Sub


Sub PutPixel (vram as Byte Ptr, x As Long, y As Long, c as Byte)
    Write3C4 &H2, PlaneSelect(x Mod 4)
    vram[(x + 320 * y) \ 4] = c

    ' ovedraw checking
    'Write3CE &H4, x Mod 4
    'vram[(x + 320 * y) \ 4] = vram[(x + 320 * y) \ 4] + 6
End Sub

Function PlaneSelect(planeno As Long) As Byte
    Select Case planeno
        Case 0
            PlaneSelect = 1
        Case 1
            PlaneSelect = 2
        Case 2
            PlaneSelect = 4
        Case 3
            PlaneSelect = 8
    End Select
End Function


' Function: Triangle
' Draws an opaque, edge-precise, no-overdraw triangle
' vram - pointer to video memory
' x1 - first x coordinate
' y1 - first y coordinate
' x2 - second x coordinate
' y2 - second y coordinate
' x3 - third x coordinate
' y3 - third y coordinate
' c - color to render with
Sub Triangle(vram As Byte Ptr, x1 As Long, y1 As Long, x2 As Long, y2 As Long, x3 As Long, y3 As Long, c as Byte)



    ' todo: hand optimize to assembly
    Dim minx As long, maxx As Long, mincount As Long, maxcount As Long
    Dim loopx As Long, halfx As Long, loopy As Long

    Dim topy As Long, topyadd As Long, topysub As Long, topystep As Long
    Dim boty As Long, botyadd As Long, botysub As Long, botystep As Long
    Dim topyfrac As Long, botyfrac As Long

    Dim temp as long
    ' sort points in order. floating bubble sort
    ' x1 will become leftmost, x3 rightmost, x2 in the middle
    ' this should fix a lot of code duplication later on
    If x1 > x2 Then
        temp = x1
        x1 = x2
        x2 = temp
        temp = y1
        y1 = y2
        y2 = temp
    End If

    If x2 > x3 Then
        temp = x2
        x2 = x3
        x3 = temp
        temp = y2
        y2 = y3
        y3 = temp
    End If

    If x1 > x2 Then
        temp = x1
        x1 = x2
        x2 = temp
        temp = y1
        y1 = y2
        y2 = temp
    End If

    minx = x1
    maxx = x3
    halfx = x2
    If minx < 0 Then minx = 0
    If maxx > 319 Then maxx = 319
    ' check if the triangle is visible
    If maxx > minx Then

        boty = y1
        botystep = (y3-y1) \ (x3-x1)
        botyadd = (y3-y1) Mod (x3-x1)
        botysub = (x3-x1)
        botyfrac = 0

        'Split the triangle in two
        If halfx > minx Then

            topy = y1
            topystep = (y2-y1) \ (x2-x1)
            topyadd = (y2-y1) Mod (x2-x1)
            topysub = (x2-x1)
            topyfrac = 0

            For loopx = minx to halfx - 1

                Write3C4 &H2, PlaneSelect(loopx Mod 4)

                If topy <= boty Then
                    For loopy = topy To boty - 1
                        vram[ (loopx + 320 * loopy) \ 4] = c
                    Next loopy
                Else
                    For loopy = boty To topy - 1
                        vram[ (loopx + 320 * loopy) \ 4] = c
                    Next loopy
                End If

                topy = topy + topystep
                topyfrac = topyfrac + topyadd
                If topyfrac > topysub Then
                    topyfrac = topyfrac - topysub
                    topy = topy + 1
                End If
                If topyfrac < -topysub Then
                    topyfrac = topyfrac + topysub
                    topy = topy - 1
                End If

                boty = boty + botystep
                botyfrac = botyfrac + botyadd
                If botyfrac > botysub Then
                    botyfrac = botyfrac - botysub
                    boty = boty + 1
                End If
                If botyfrac < -botysub Then
                    botyfrac = botyfrac + botysub
                    boty = boty - 1
                End If

            Next loopx
        End If

        If halfx < maxx Then

            topy = y2
            topystep = (y3-y2) \ (x3-x2)
            topyadd = (y3-y2) Mod (x3-x2)
            topysub = (x3-x2)
            topyfrac = 0

            For loopx = halfx to maxx - 1

                Write3C4 &H2, PlaneSelect(loopx mod 4)

                If topy <= boty Then
                    For loopy = topy To boty - 1
                        vram[ (loopx + 320 * loopy) \ 4] = c
                    Next loopy
                Else
                    For loopy = boty To topy - 1
                        vram[ (loopx + 320 * loopy) \ 4] = c
                    Next loopy
                End If

                topy = topy + topystep
                topyfrac = topyfrac + topyadd
                If topyfrac > topysub Then
                    topyfrac = topyfrac - topysub
                    topy = topy + 1
                End If
                If topyfrac < -topysub Then
                    topyfrac = topyfrac + topysub
                    topy = topy - 1
                End If

                boty = boty + botystep
                botyfrac = botyfrac + botyadd
                If botyfrac > botysub Then
                    botyfrac = botyfrac - botysub
                    boty = boty + 1
                End If
                If botyfrac < -botysub Then
                    botyfrac = botyfrac + botysub
                    boty = boty - 1
                End If

            Next loopx
        End if

    End If
End Sub
